package etrobo.sample2010;

import lejos.nxt.*;
import lejos.nxt.comm.*;


// 参考元 ---------------------------------------------------------------------
/*
 ******************************************************************************
 **	ファイル名 : sample.c
 **
 **	概要       : 2輪倒立振子ライントレースロボットのTOPPERS/ATK(OSEK)用サンプルプログラム
 **
 ******************************************************************************
 **/
//-----------------------------------------------------------------------------
public class Sample1Main extends Thread {
	public static void main(String[] args) {

		LCD.drawString("Push touch sensor!", 0, 0);
		TouchSensor touch = new TouchSensor(SensorPort.S1);
		while (touch.isPressed() == false)
			; /* タッチセンサ押下待機 */


		/* BT接続方法のボタン入力 */
		String[] btMessageArray = {"Not Connect   ", "Sensor Monitor", "RConsole      "};
		int btIndex = 0;

		LCD.drawString("BT Connection     ", 0,0);
		LCD.drawString(btMessageArray[btIndex], 0,1);
		boolean flg = true;
		while(flg) {
			if(Button.ENTER.isPressed()){
				flg = false;
			}
			if(Button.RIGHT.isPressed()){
				btIndex += 1;
			}
			btIndex %= btMessageArray.length;
			LCD.drawString(btMessageArray[btIndex], 0,1);
			try {
				Thread.sleep(200); /* 約200msec周期処理 */
			} catch (InterruptedException e) {
			}
		}
		LCD.clear();

		/* BT接続の設定 */
		float period = 0.00500000019F;
		LCPBTResponder lcpThread;
		if(btIndex == 0){
			period = 0.00500000019F;
		}
		else{
			Bluetooth.setPower(true);
			period = 0.00600000019F;
			if(btIndex == 1){
				lcpThread = new LCPBTResponder();
				lcpThread.setDaemon(true);
				lcpThread.start();
			}
			else if(btIndex == 2){
				RConsole.openBluetooth(0);
			}
		}

		Setting setting = new Setting();
		setting.setParameters(Variables.getInsatnce(), touch);

		LCD.clear();
		LCD.drawString("Push touch sensor!", 0, 0);
		while (touch.isPressed() == false)
			; /* タッチセンサ押下待機 */
		/* タッチセンサによりロボット走行開始 */

		Driver driver = new Driver(period);
		Thread thread = new Thread(driver);
		thread.setPriority(MAX_PRIORITY);
		thread.start();

//		FallDetector fall = new FallDetector();
//		Thread fallThread = new Thread(fall);
//		fallThread.start();

//		int tacho1 = MotorPort.getTachoCountById(2);

		/* LEFTボタン(左)によりロボット停止 */
		while (true) {
//			int tacho2 = MotorPort.getTachoCountById(2);
//			RConsole.println("tacho	"+tacho1+"	"+tacho2);
//			if ((Button.LEFT.isPressed() == true) || (driver.isFall() == true) || (tacho2 < tacho1 - 50)){
			if ((Button.LEFT.isPressed() == true) || (driver.isFall() == true)){
//			if ((Button.LEFT.isPressed() == true)){
				break;
			}
			else{
//				tacho1 = tacho2;
			}
			try {
				Thread.sleep(200); /* 約200msec周期処理 */
			} catch (InterruptedException e) {
			}
		}
		driver.stopRunning();
//		fall.stop();

		/* ESCAPEボタン(下)によりプログラム終了 */
		while (true) {
			if (Button.ESCAPE.isPressed() == true)
				break;
		}
	}
}
