/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.oauth.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.evernote.client.conn.ApplicationInfo;
import com.evernote.client.conn.mobile.TEvernoteHttpClient;
import com.evernote.client.oauth.EvernoteAuthToken;
import com.evernote.client.oauth.android.AuthenticationResult;
import com.evernote.client.oauth.android.EvernoteOAuthActivity;
import com.evernote.edam.notestore.NoteStore;
import java.io.File;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class EvernoteSession {
    private static final String KEY_AUTHTOKEN = "evernote.authToken";
    private static final String KEY_NOTESTOREURL = "evernote.notestoreUrl";
    private static final String KEY_WEBAPIURLPREFIX = "evernote.webApiUrlPrefix";
    private static final String KEY_USERID = "evernote.userId";
    private ApplicationInfo applicationInfo;
    private AuthenticationResult authenticationResult;
    private File tempDir;

    public EvernoteSession(ApplicationInfo applicationInfo, File tempDir) {
        this.applicationInfo = applicationInfo;
        this.tempDir = tempDir;
    }

    public EvernoteSession(ApplicationInfo applicationInfo, AuthenticationResult sessionInfo, File tempDir) {
        this(applicationInfo, tempDir);
        this.authenticationResult = sessionInfo;
    }

    public EvernoteSession(ApplicationInfo applicationInfo, SharedPreferences sessionInfo, File tempDir) {
        this(applicationInfo, tempDir);
        this.authenticationResult = this.getAuthenticationResult(sessionInfo);
    }

    private AuthenticationResult getAuthenticationResult(SharedPreferences prefs) {
        String authToken = prefs.getString(KEY_AUTHTOKEN, "");
        String notestoreUrl = prefs.getString(KEY_NOTESTOREURL, "");
        String webApiUrlPrefix = prefs.getString(KEY_WEBAPIURLPREFIX, "");
        int userId = prefs.getInt(KEY_USERID, -1);
        if (!(authToken.isEmpty() || notestoreUrl.isEmpty() || webApiUrlPrefix.isEmpty() || userId <= 0)) {
            return new AuthenticationResult(authToken, notestoreUrl, webApiUrlPrefix, userId);
        }
        return null;
    }

    public boolean isLoggedIn() {
        return this.authenticationResult != null;
    }

    public void logOut(SharedPreferences prefs) {
        this.authenticationResult = null;
        SharedPreferences.Editor editor = prefs.edit();
        editor.remove(KEY_AUTHTOKEN);
        editor.remove(KEY_NOTESTOREURL);
        editor.remove(KEY_WEBAPIURLPREFIX);
        editor.remove(KEY_USERID);
        editor.apply();
    }

    public String getAuthToken() {
        if (this.authenticationResult != null) {
            return this.authenticationResult.getAuthToken();
        }
        return null;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    public NoteStore.Client createNoteStore() throws TTransportException {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException();
        }
        TEvernoteHttpClient transport = new TEvernoteHttpClient(this.authenticationResult.getNoteStoreUrl(), this.applicationInfo.getUserAgent(), this.tempDir);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new NoteStore.Client((TProtocol)protocol, (TProtocol)protocol);
    }

    public void authenticate(Context context) {
        Intent intent = new Intent(context, EvernoteOAuthActivity.class);
        intent.putExtra("EVERNOTE_HOST", this.applicationInfo.getEvernoteHost());
        intent.putExtra("CONSUMER_KEY", this.applicationInfo.getConsumerKey());
        intent.putExtra("CONSUMER_SECRET", this.applicationInfo.getConsumerSecret());
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public boolean completeAuthentication(SharedPreferences prefs) {
        boolean result = false;
        if (EvernoteOAuthActivity.authToken != null) {
            EvernoteAuthToken token = EvernoteOAuthActivity.authToken;
            this.authenticationResult = new AuthenticationResult(token.getToken(), token.getNoteStoreUrl(), token.getWebApiUrlPrefix(), token.getUserId());
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(KEY_AUTHTOKEN, token.getToken());
            editor.putString(KEY_NOTESTOREURL, token.getNoteStoreUrl());
            editor.putString(KEY_WEBAPIURLPREFIX, token.getWebApiUrlPrefix());
            editor.putInt(KEY_USERID, token.getUserId());
            editor.apply();
            result = true;
        } else {
            result = !EvernoteOAuthActivity.startedAuthentication;
        }
        EvernoteOAuthActivity.reset();
        return result;
    }
}

