package com.yuji.ec;

import android.content.Context;

import com.evernote.client.oauth.android.EvernoteSession;
import com.yuji.ec.common.Constant;
import com.yuji.ec.db.DatabaseHelper;
import com.yuji.ec.service.NoteUpdatorService;
import com.yuji.ec.utility.EditPrefUtil;
import com.yuji.ec.utility.EvernoteUtil;
import com.yuji.ec.utility.OAuthUtil;

public class Initialize {
	private static final String EVER_CLIP_ACTIVITY = "EverClipActivity";
	private static boolean isInit = true;
	private static boolean isInit2 = true;

	public static void initialize(Context context) {
		if (!isInit) {
			return;
		}
		
		EditPrefUtil pref = new EditPrefUtil(context);
		pref.getLong(Constant.PREF_LOGIN_DATE, 0L);
		pref.getInt(Constant.PREF_AUTO_UPDATE, 0);
		pref.getLong(Constant.PREF_UPDATE_TIME, 0L);
		pref.update();
		
		DatabaseHelper.init(context);
		NoteUpdatorService.init(context);
		EverClipActivity.init(true);
		
		try {
			OAuthUtil authUtil = OAuthUtil.getInstance();
			EvernoteSession session = authUtil.setupSession(context);
			EvernoteUtil.getInstance().setSession(session);
		}
		catch (Throwable t){
			return;
		}
		isInit = false;
	}

	public static void initialize(Context context, String name) {
		if (!isInit2) {
			return;
		}
		if (name.equals(EVER_CLIP_ACTIVITY)){
			return;
		}
		
//		EvernoteUtil util = EvernoteUtil.getInstance();
//		String username = PasswordUtil.getUsername(context);
//		String password = PasswordUtil.getPassword(context);
//		if (!CommonUtil.isNull(username) && !CommonUtil.isNull(password)) {
//			util.setConfig(username, password);
//		}
		
		isInit2 = false;	
	}
}
