package com.yuji.ec;

import android.content.Context;

import com.yuji.ec.common.CommonUtil;
import com.yuji.ec.db.DatabaseHelper;
import com.yuji.ec.service.NoteUpdatorService;
import com.yuji.ec.utility.EvernoteUtil;
import com.yuji.ec.utility.PasswordUtil;

public class Initialize {
	private static final String EVER_CLIP_ACTIVITY = "EverClipActivity";
	private static boolean isInit = true;
	private static boolean isInit2 = true;

	public static void initialize(Context context) {
		if (!isInit) {
			return;
		}
		
		DatabaseHelper.init(context);
		NoteUpdatorService.init(context);
		
		isInit = false;
	}

	public static void initialize(Context context, String name) {
		if (!isInit2) {
			return;
		}
		if (name.equals(EVER_CLIP_ACTIVITY)){
			return;
		}
		
		EvernoteUtil util = EvernoteUtil.getInstance();
		String username = PasswordUtil.getUsername(context);
		String password = PasswordUtil.getPassword(context);
		if (!CommonUtil.isNull(username) && !CommonUtil.isNull(password)) {
			util.setConfig(username, password);
		}
		
		isInit2 = false;	
	}
}
