package com.yuji.ef;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.TextView;

import com.yuji.ef.dao.Node;

public class BookListViewArrayAdapter extends ArrayAdapter<Node> {
    private LayoutInflater inflater;

    public BookListViewArrayAdapter(Context context, int resourceId, List<Node> items) {
        super(context, resourceId, items);
        this.inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent){
        View view = convertView;  
        if(view == null){  
            view = inflater.inflate(R.layout.check_list_item_1, null);  
        }      

        Node item = getItem(position);
        
        boolean selected = item.isSelected();
        
        CheckBox checkbox = (CheckBox)view.findViewById(R.id.checkBox);
        checkbox.setEnabled(false);
        checkbox.setChecked(selected);

        TextView text = (TextView)view.findViewById(R.id.text2);  
        text.setText(item.getName());  
        
        return view;
    }
    
}
