package com.yuji.ef.dao;

import java.util.List;

import com.yuji.ef.LabelIconView;

public class Node {
	public static final int TYPE_NONE = -1;
	public static final int TYPE_ROOT = 0;
	public static final int TYPE_BOOK = 1;
	public static final int TYPE_DIR = 2;
	public static final int TYPE_NOTE = 3;
	
	public enum Status {
		NONE, OPEN, CLOSE
	};

	private long id = -1;
	// private Node parent = null;
	private long parent = -1;
	protected String guid = null;
	protected String name = null;
	protected LabelIconView view = null;
	protected List<Long> children = null;
	protected boolean selected = false;

	public static int getStatusCode(Status status) {
		if (status == Status.OPEN) {
			return 1;
		}
		if (status == Status.CLOSE) {
			return 2;
		}
		return 0;
	}

	public static Status getStatus(int code) {
		switch (code) {
		case 1:
			return Status.OPEN;
		case 2:
			return Status.CLOSE;
		}
		return Status.NONE;
	}

	public Node(String name, LabelIconView view) {
		this.name = name;
		this.view = view;

//		if (view != null) {
//			view.setNodeId(this.getId());
//		}
	}

	public int getType() {
		return TYPE_NONE;
	}

	public void setView(LabelIconView view) {
		this.view = view;
//		if (view != null) {
//			view.setNodeId(this.getId());
//		}
	}

	public long getId() {
		return id;
	}

	public long getParent() {
		return parent;
	}

	public void setId(long id) {
		this.id = id;
	}

	public void setGuid(String guid) {
		this.guid = guid;
	}

	public void setParent(long parent) {
		this.parent = parent;
	}

	public List<Long> getChildren() {
		return children;
	}

	public String getGuid() {
		return guid;
	}

	public String getName() {
		return name;
	}

	public void add(long node) {
		if (children == null) {
			return;
		}
		children.add(node);
	}

	public void remove(long node) {
		if (children == null) {
			return;
		}
		children.remove(node);
	}

	public LabelIconView getView() {
		return view;
	}

	public int getIconId() {
		return -1;
	}

	public Status getStatus() {
		return Status.NONE;
	}

	public void setStatus(Status status) {

	}

	public void toggleStatus() {

	}

	public int getStatusIconId() {
		return -1;
	}

	public String getChildrenString() {
		if (children == null || children.size() <= 0) {
			return "";
		}
		return concatChildren(children);
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	@Override
	public boolean equals(Object obj){
		if (!(obj instanceof Node)){
			return false;
		}
		Node node = (Node)obj;
		return this.getId() == node.getId();
	}
	
	@Override
	public String toString() {
		return name + "\t" + guid + "\t" + getClass().getCanonicalName() + "\t"
				+ id + "\t" + parent;
	}

	public static String concatChildren(List<Long> children) {
		StringBuffer sb = new StringBuffer();
		for (long id : children) {
			if (sb.length() > 0) {
				sb.append(NodeDao.DELM);
			}
			sb.append(String.valueOf(id));
		}
		return sb.toString();
	}
}
