package com.yuji.ef.utility;

import android.util.Log;

public class Debug {
	public static final String ON_CREATE = "onCreate";
	public static final String ON_DESTROY = "onDestroy";
	public static final String ON_START = "onStart";
	public static final String ON_STOP = "onStop";
	public static final String ON_PAUSE = "onPause";
	public static final String ON_RESTART = "onRestart";
	public static final String ON_RESUME = "onResume";
	public static final String ON_REBIND = "onRebind";
	public static final String ON_UNBIND = "onUnbind";

	private static final String FILTER = "com.yuji.ef";

	public static void d(Object target, String msg1, String msg2){
		d(target, msg1, msg2, null, null, null);
	}
	
	public static void d(Object target, String msg1, String msg2, String msg3){
		d(target, msg1, msg2, msg3, null, null);
	}
	
	public static void d(Object target, String msg1, String msg2, String msg3, String msg4){
		d(target, msg1, msg2, msg3, msg4, null);
	}
	
	public static void d(Object target, String msg1, String msg2, String msg3, String msg4, String msg5){
		if (!Log.isLoggable(FILTER, Log.DEBUG)){
			return;
	 	}
		StringBuffer sb = new StringBuffer();
		if (msg1 != null){
			sb.append(msg1);
		}
		if (msg2 != null){
			sb.append(msg2);
		}
		if (msg3 != null){
			sb.append(msg3);
		}
		if (msg4 != null){
			sb.append(msg4);
		}
		if (msg5 != null){
			sb.append(msg5);
		}
		d(target, sb.toString(), (Throwable)null);
	}
	
	public static void d(Object target, String msg){
		d(target, msg, null, Log.DEBUG);
	}

	public static void d(Object target, String msg, Throwable t){
//		if (t != null){
//			l(t.getMessage());
//		}
		d(target, msg, t, Log.DEBUG);
	}

	public static void i(Object target, String msg){
		i(target, msg, null);
	}

	public static void i(Object target, String msg, Throwable t){
		d(target, msg, t, Log.INFO);
	}

	private static void d(Object target, String msg, Throwable t, int level){
		if (!Log.isLoggable(FILTER, level)){
			return;
	 	}
	
		String text = target.getClass().getName();
		if (msg != null){
			 text += " " + msg;			
		}
		if (t == null){
			Log.d(FILTER, text);
		}
		else {
			Log.d(FILTER, text, t);			
		}
	}
		
	public static boolean isDebug(){
		return Log.isLoggable(FILTER, Log.DEBUG);
	}
}
