package com.yuji.ef.utility;

import java.io.File;
import java.util.Calendar;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;

import com.evernote.client.conn.ApplicationInfo;
import com.evernote.client.oauth.android.EvernoteSession;
import com.yuji.ef.common.Constant;
import com.yuji.ef.pref.EditPrefUtil;
import com.yuji.ef.pref.PrefUtil;
import com.yuji.ef.pref.PrefUtilImpl;

public class OAuthUtil {
	private static final String CONSUMER_KEY = "yuji-k64613";
	// TODO
	// Debian
	//private static final String CONSUMER_SECRET = "G5r7t1nHC+AIf6dYHuIVC7Jr/iVIMtgMZ0PObN6xV2Q=";
	// Mac
	private static final String CONSUMER_SECRET = "a/E89hlW9foWMh/ReopNucX+/WQ9WTs4YwvHP1cGH9s=" ;	
	private static final String APP_DATA_PATH = "/Android/data/com.yuji.ef/temp/";
	private static final String EVERNOTE_HOST = "www.evernote.com";

	private static final String APP_NAME = "FolderErver";
	private static final String APP_VERSION = "1.0.0";

	private static OAuthUtil instance = null;
	private static String consumerSecret = null;
	private EvernoteSession session;

	public static OAuthUtil getInstance() {
		if (instance == null) {
			instance = new OAuthUtil();
		}
		return instance;
	}

	private OAuthUtil() {

	}

	public EvernoteSession setupSession(Context context) {
		if (consumerSecret == null){
			Encryption en = Encryption.getInstance();
			//String s = en.getEncrypted(context, "");
			consumerSecret = en.getDecrypted(context, CONSUMER_SECRET);
		}
		
		ApplicationInfo info = new ApplicationInfo(CONSUMER_KEY,
				consumerSecret, EVERNOTE_HOST, APP_NAME, APP_VERSION);

		// Retrieve persisted authentication information
		session = new EvernoteSession(info,
				getPreferencesForAuthData(context), getTempDir());

		// セッションの期限切れをチェック
		EditPrefUtil pref = new EditPrefUtil(context);
		Calendar cal = Calendar.getInstance();
		long now = cal.getTimeInMillis();
		long loginTime = pref.getLong(Constant.PREF_LOGIN_DATE);
		long diff = (now - loginTime) / 1000;

		//if (loginTime > 0 && diff > 60){ // 1分
		if (loginTime > 0 && diff > (365 - 1) * 24 * 60 * 60){ // 余裕を持って1日前に削除
			logout(context);
			pref.put(Constant.PREF_LOGIN_DATE, 0L);
			pref.update();

			session = new EvernoteSession(info,
					getPreferencesForAuthData(context), getTempDir());
		}
		
		return session;
	}

	public boolean isCompleteAuth(Context context) {
		if (session == null) {
			return false;
		}
		return session
				.completeAuthentication(getPreferencesForAuthData(context));
	}

	public SharedPreferences getPreferencesForAuthData(Context context) {
		PrefUtil pref = new PrefUtilImpl(context);
		return pref.getSharedPreferences();
	}

	private File getTempDir() {
		return new File(Environment.getExternalStorageDirectory(),
				APP_DATA_PATH);
	}

	public EvernoteSession getSession() {
		return session;
	}

	public void logout(Context context){
	    session.logOut(getPreferencesForAuthData(context));	

	    EditPrefUtil pref = new EditPrefUtil(context);
		pref.put(Constant.PREF_LOGIN_DATE, 0L);
		pref.update();
	}

	public void setLoginTime(Context context) {
		Calendar cal = Calendar.getInstance();
		long t = cal.getTimeInMillis();
		EditPrefUtil pref = new EditPrefUtil(context);
		pref.put(Constant.PREF_LOGIN_DATE, t);
		pref.update();
	}
}
