package com.yuji.ef;
//package com.evernote.android.sample;

import java.io.File;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.evernote.client.conn.ApplicationInfo;
import com.evernote.client.oauth.android.AuthenticationResult;
import com.evernote.client.oauth.android.EvernoteSession;
import com.yuji.ef.utility.BaseActivity;
import com.yuji.ef.utility.EvernoteUtil;

/**
 * This simple Android app demonstrates how to integrate with the Evernote Cloud
 * API (aka EDAM) to create a note.
 * 
 * In this sample, the user authorizes access to their account using OAuth and
 * chooses an image from the device's image gallery. The image is then saved
 * directly to Evernote using the Cloud API.
 */
public class OAuthActivity extends BaseActivity {

	/***************************************************************************
	 * You MUST change the following values to run this sample application. *
	 ***************************************************************************/

	// Your Evernote API key. See http://dev.evernote.com/documentation/cloud/
	// Please obfuscate your code to help keep these values secret.
	private static final String CONSUMER_KEY = "yuji-k64613";
	private static final String CONSUMER_SECRET = "98b2cbf35f747d2d";

	/***************************************************************************
	 * Change these values as needed to use this code in your own application. *
	 ***************************************************************************/

	// Name of this application, for logging
	private static final String TAG = "HelloEDAM";

	// A directory on disk where your application stores temporary data
	private static final String APP_DATA_PATH = "/Android/data/com.yuji.ef/temp/";

	// Change to "www.evernote.com" to use the Evernote production service
	// instead of the sandbox
	// private static final String EVERNOTE_HOST = "sandbox.evernote.com";
	private static final String EVERNOTE_HOST = "www.evernote.com";

	private static final String APP_NAME = "Evernote Android Sample";
	private static final String APP_VERSION = "1.0";

	/***************************************************************************
	 * The following values are simply part of the demo application. *
	 ***************************************************************************/

	// Activity result request codes
	private static final int SELECT_IMAGE = 1;

	// The ENML preamble to every Evernote note.
	// Note content goes between <en-note> and </en-note>
	private static final String NOTE_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
			+ "<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">"
			+ "<en-note>";

	// The ENML postamble to every Evernote note
	private static final String NOTE_SUFFIX = "</en-note>";

	// Used to interact with the Evernote web service
	private EvernoteSession session;

	// UI elements that we update
	private Button btnAuth;
	private Button btnSave;
	private Button btnSelect;
	private TextView msgArea;

	// The path to and MIME type of the currently selected image from the
	// gallery
	private String filePath;
	private String mimeType;
	private String fileName;

	private boolean isInit = true;
	
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.oauth);

//		msgArea = (TextView) findViewById(R.id.message);
//		btnAuth = (Button) findViewById(R.id.auth_button);
//		btnSelect = (Button) findViewById(R.id.select_button);
//		btnSave = (Button) findViewById(R.id.save_button);

		setupSession();
	}

	@Override
	public void onResume() {
		super.onResume();

		// Complete the Evernote authentication process if necessary
		// TODO
		//if (!session.completeAuthentication()) {
		if (!isInit && !session.completeAuthentication()) {
			// We only want to do this when we're resuming after
			// authentication...
			Toast.makeText(this, "Evernote login failed", Toast.LENGTH_LONG)
					.show();
		}

		updateUi();
		
		// ADD
		if (isInit){
			isInit = false;
		}
		else {
			EvernoteUtil util = EvernoteUtil.getInstance();
			util.setSession(session);
			finish();
		}
	}

	/**
	 * Setup the EvernoteSession used to access the Evernote API.
	 */
	private void setupSession() {
		ApplicationInfo info = new ApplicationInfo(CONSUMER_KEY,
				CONSUMER_SECRET, EVERNOTE_HOST, APP_NAME, APP_VERSION);

		String authToken = null;
		String noteStoreUrl = null;
		String webApiUrlPrefix = null;
		int userId = 0;
		// boolean hasCachedEvernoteCredentials = true;
		boolean hasCachedEvernoteCredentials = false;

		// TODO Retreived the cached Evernote AuthenticationResult if it exists
		if (hasCachedEvernoteCredentials) {
			AuthenticationResult result = new AuthenticationResult(authToken,
					noteStoreUrl, webApiUrlPrefix, userId);
			session = new EvernoteSession(info, result, getTempDir());
		} else {
			session = new EvernoteSession(info, getTempDir());
		}

		updateUi();
		
		// ADD
		try {
			startAuth(null);
		}
		catch (Throwable t){
			t.printStackTrace();
		}
	}

	/**
	 * Update the UI based on Evernote authentication state.
	 */
	private void updateUi() {
		if (session.isLoggedIn()) {
//			btnAuth.setText(R.string.label_log_out);
//			btnSave.setEnabled(true);
//			btnSelect.setEnabled(true);
		} else {
//			btnAuth.setText(R.string.label_log_in);
//			btnSave.setEnabled(false);
//			btnSelect.setEnabled(false);
		}
	}

	/**
	 * Called when the user taps the "Select Image" button.
	 * 
	 * Sends the user to the image gallery to choose an image to share.
	 */
	public void startAuth(View view) {
//		if (session.isLoggedIn()) {
//			session.logOut();
//		} else {
//			session.authenticate(this);
//		}
		if (session.isLoggedIn()) {
			session.logOut();
		}
		session.authenticate(this);

		updateUi();
	}

	/**
	 * Get a temporary directory that can be used by this application to store
	 * potentially large files sent to and retrieved from the Evernote API.
	 */
	private File getTempDir() {
		return new File(Environment.getExternalStorageDirectory(),
				APP_DATA_PATH);
	}

	/**
	 * Called when the control returns from an activity that we launched.
	 */
	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		if (requestCode == SELECT_IMAGE) {
			// Callback from our 'startSelectImage' action
			if (resultCode == Activity.RESULT_OK) {
//				endSelectImage(data);
			}
		}
	}
}
