package com.yuji.ef.dao;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.yuji.ef.common.CommonUtil;
import com.yuji.ef.utility.Debug;

public class NodeDaoImpl implements IDao<Node>, NodeDao {
	private static IDao<Node> instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateChildrenStmt = null;
	private SQLiteStatement updateStatusStmt = null;
	private SQLiteStatement updateNameStmt = null;
	private SQLiteStatement updateGuidStmt = null;
	private SQLiteStatement updateSelectedStmt = null;
	private SQLiteStatement updateNoteFlagStmt = null;
	private SQLiteStatement updateFlagStmt = null;
	private SQLiteStatement updateParentStmt = null;
	private SQLiteStatement deleteStmt = null;
	private SQLiteStatement deleteIdStmt = null;

	public static IDao<Node> getInstance() {
		if (instance == null) {
			instance = new NodeDaoImpl();
		}
		return instance;
	}

	protected NodeDaoImpl() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#onCreate(android.database.sqlite.SQLiteDatabase)
	 */
	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE Node (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "TYPE INTEGER,"
				+ "GUID TEXT," + "PARENT INTEGER," + "NAME TEXT,"
				+ "CHILDREN TEXT," + "STATUS INTEGER," + "SELECTED INTEGER,"
				 + "FLAG INTEGER"
				+ ");");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#init(android.database.sqlite.SQLiteDatabase)
	 */
	@Override
	public void init(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO Node (" + "TYPE,"
				+ "GUID," + "PARENT," + "NAME," + "CHILDREN," + "STATUS"
				+ ") VALUES (" + "?,?,?,?,?,?" + ");");
		updateChildrenStmt = db
				.compileStatement("UPDATE Node SET CHILDREN = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateStatusStmt = db
				.compileStatement("UPDATE Node SET STATUS = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateNameStmt = db.compileStatement("UPDATE Node SET NAME = ? WHERE "
				+ android.provider.BaseColumns._ID + " = ?");
		updateGuidStmt = db
				.compileStatement("UPDATE Node SET GUID = ?, TYPE = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateSelectedStmt = db
				.compileStatement("UPDATE Node SET SELECTED = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateNoteFlagStmt = db
				.compileStatement("UPDATE Node SET FLAG = ? WHERE "
						+ "TYPE = ?");
		updateFlagStmt = db
				.compileStatement("UPDATE Node SET FLAG = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		updateParentStmt = db
				.compileStatement("UPDATE Node SET PARENT = ? WHERE "
						+ android.provider.BaseColumns._ID + " = ?");
		deleteStmt = db.compileStatement("DELETE FROM Node");
		deleteIdStmt = db.compileStatement("DELETE FROM Node WHERE "
				+ android.provider.BaseColumns._ID + " = ?");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#start(android.database.sqlite.SQLiteDatabase)
	 */
	@Override
	public void start(SQLiteDatabase db) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#search()
	 */
	@Override
	public List<Node> search() {
		return search(DatabaseHelper.getInstance().getSQLiteDatabase(), null,
				null, null);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#searchRoot()
	 */
	@Override
	public Node searchRoot() {
		return searchRoot(DatabaseHelper.getInstance().getSQLiteDatabase());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#searchRoot(android.database.sqlite.SQLiteDatabase
	 * )
	 */
	@Override
	public Node searchRoot(SQLiteDatabase db) {
		String selection = "TYPE = ?";
		String[] selectionArgs = { String.valueOf(Node.TYPE_ROOT) };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	@Override
	public List<Node> searchNote() {
		return searchNote(DatabaseHelper.getInstance().getSQLiteDatabase());
	}

	@Override
	public List<Node> searchNote(SQLiteDatabase db) {
		String selection = "TYPE = ?";
		String[] selectionArgs = { String.valueOf(Node.TYPE_NOTE) };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		return list;
	}

	@Override
	public List<Node> searchBook() {
		return searchBook(DatabaseHelper.getInstance().getSQLiteDatabase());
	}

	@Override
	public List<Node> searchBook(SQLiteDatabase db) {
		String selection = "TYPE = ?";
		String[] selectionArgs = { String.valueOf(Node.TYPE_BOOK) };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		return list;
	}

	@Override
	public List<Node> searchSelectedBook() {
		return searchSelectedBook(DatabaseHelper.getInstance()
				.getSQLiteDatabase());
	}

	@Override
	public List<Node> searchSelectedBook(SQLiteDatabase db) {
		String selection = "TYPE = ? AND SELECTED = ?";
		String[] selectionArgs = { String.valueOf(Node.TYPE_BOOK), "1" };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		return list;
	}

	@Override
	public List<Node> searchNoteByFlag(int flag) {
		return searchNoteByFlag(DatabaseHelper.getInstance()
				.getSQLiteDatabase(), flag);
	}

	@Override
	public List<Node> searchNoteByFlag(SQLiteDatabase db, int flag) {
		String selection = "TYPE = ? AND FLAG = ?";
		String[] selectionArgs = { String.valueOf(Node.TYPE_NOTE),
				String.valueOf(flag) };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		return list;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#searchById(long)
	 */
	@Override
	public Node searchById(long id) {
		return searchById(DatabaseHelper.getInstance().getSQLiteDatabase(), id);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#searchById(android.database.sqlite.SQLiteDatabase
	 * , long)
	 */
	@Override
	public Node searchById(SQLiteDatabase db, long id) {
		String selection = android.provider.BaseColumns._ID + " = ?";
		String[] selectionArgs = { String.valueOf(id) };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#searchByGuid(android.database.sqlite.SQLiteDatabase
	 * , java.lang.String)
	 */
	@Override
	public Node searchByGuid(SQLiteDatabase db, String guid) {
		String selection = "GUID = ?";
		String[] selectionArgs = { guid };
		String orderBy = null;
		List<Node> list = search(db, selection, selectionArgs, orderBy);
		if (list.size() <= 0) {
			return null;
		}
		return list.get(0);
	}

	private List<Node> search(SQLiteDatabase db, String selection,
			String[] selectionArgs, String orderBy) {
		List<Node> list = new ArrayList<Node>();
		Cursor cursor = null;
		try {
			NodeFactory factory = NodeFactory.getInstance();

			cursor = db.query("Node", new String[] {
					android.provider.BaseColumns._ID, "TYPE", "GUID", "PARENT",
					"NAME", "CHILDREN", "STATUS", "SELECTED" }, selection,
					selectionArgs, null, null, orderBy);
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				// TODO Factory
				// Node Node = new Node(
				// cursor.getLong(0),
				// cursor.getString(1),
				// cursor.getString(2),
				// cursor.getLong(3),
				// cursor.getLong(4));
				Node node = factory.create(cursor.getLong(0), cursor.getInt(1),
						cursor.getString(2), cursor.getLong(3),
						cursor.getString(4), cursor.getString(5),
						cursor.getInt(6), (cursor.getInt(7) != 0));
				list.add(node);
				cursor.moveToNext();
			}
		} catch (SQLException e) {
			Debug.d(this, null, e);
			list = null;
		} catch (Exception e) {
			Debug.d(this, null, e);
			list = null;
		} finally {
			if (cursor != null) {
				cursor.close();
				cursor = null;
			}
		}
		return list;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		// List<Node> list = search();
		// return list == null || list.size() <= 0;
		return this.searchRoot() == null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#add(com.yuji.ef.dao.Node)
	 */
	@Override
	public long add(Node node) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return add(db, node);
	}

	private long add(SQLiteDatabase db, Node node) {
		long id = -1;
		db.beginTransaction();
		try {
			id = addNT(node);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#addNT(com.yuji.ef.dao.Node)
	 */
	@Override
	public long addNT(Node node) {
		long id = -1;
		int i = 1;
		SQLiteStatement stmt = insertStmt;
		stmt.bindLong(i++, node.getType());
		stmt.bindString(i++, CommonUtil.nz(node.getGuid()));
		stmt.bindLong(i++, node.getParent());
		stmt.bindString(i++, node.getName());
		stmt.bindString(i++, CommonUtil.nz(node.getChildrenString()));
		stmt.bindLong(i++, Node.getStatusCode(node.getStatus()));
		id = stmt.executeInsert();
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#addChildrenId(com.yuji.ef.dao.Node, long)
	 */
	@Override
	public long addChildrenId(Node node, long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return addChildrenId(db, node, id);
	}

	private long addChildrenId(SQLiteDatabase db, Node node, long aid) {
		long id = -1;
		db.beginTransaction();
		try {
			id = addChildrenIdNT(node, aid);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#addChildrenIdNT(com.yuji.ef.dao.Node, long)
	 */
	@Override
	public long addChildrenIdNT(Node node, long id) {
		List<Long> l = node.getChildren();
		if (l.contains(id)) {
			return -1;
		}
		l.add(id);
		// node.add(id);
		return updateChildrenNT(node, Node.concatChildren(l));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateChildrenNT(com.yuji.ef.dao.Node,
	 * java.lang.String)
	 */
	@Override
	public long updateChildrenNT(Node node, String children) {
		long id = -1;
		int i = 1;
		SQLiteStatement stmt = updateChildrenStmt;
		//stmt.bindString(i++, node.getChildrenString());
		stmt.bindString(i++, children);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#remoteChildrenId(com.yuji.ef.dao.Node, long)
	 */
	@Override
	public long removeChildrenId(Node node, long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return remoteChildrenId(db, node, id);
	}

	private long remoteChildrenId(SQLiteDatabase db, Node node, long aid) {
		long id = -1;
		db.beginTransaction();
		try {
			id = removeChildrenIdNT(node, aid);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#remoteChildrenIdNT(com.yuji.ef.dao.Node,
	 * long)
	 */
	@Override
	public long removeChildrenIdNT(Node node, long id) {
		List<Long> l = node.getChildren();
		if (!l.contains(id)) {
			return -1;
		}
		l.remove(id);
		// node.add(id);
		return updateChildrenNT(node, Node.concatChildren(l));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateStatus(com.yuji.ef.dao.Node,
	 * com.yuji.ef.dao.Node.Status)
	 */
	@Override
	public long updateStatus(Node node, Node.Status status) {
		return updateStatus(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, status);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#updateStatus(android.database.sqlite.SQLiteDatabase
	 * , com.yuji.ef.dao.Node, com.yuji.ef.dao.Node.Status)
	 */
	@Override
	public long updateStatus(SQLiteDatabase db, Node node, Node.Status status) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateStatusNT(node, status);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateStatusNT(com.yuji.ef.dao.Node,
	 * com.yuji.ef.dao.Node.Status)
	 */
	@Override
	public long updateStatusNT(Node node, Node.Status status) {
		long id = -1;
		int i = 1;
		int code = Node.getStatusCode(status);

		SQLiteStatement stmt = updateStatusStmt;
		stmt.bindLong(i++, code);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateName(com.yuji.ef.dao.Node,
	 * java.lang.String)
	 */
	@Override
	public long updateName(Node node, String name) {
		return updateName(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#updateName(android.database.sqlite.SQLiteDatabase
	 * , com.yuji.ef.dao.Node, java.lang.String)
	 */
	@Override
	public long updateName(SQLiteDatabase db, Node node, String name) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateNameNT(node, name);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateNameNT(com.yuji.ef.dao.Node,
	 * java.lang.String)
	 */
	@Override
	public long updateNameNT(Node node, String name) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateNameStmt;
		stmt.bindString(i++, name);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	@Override
	public long updateGuid(Node node, String guid) {
		return updateGuid(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, guid);
	}

	@Override
	public long updateGuid(SQLiteDatabase db, Node node, String guid) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateGuid(node, guid);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	@Override
	public long updateGuidNT(Node node, String guid) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateGuidStmt;
		if (CommonUtil.isNull(guid)) {
			stmt.bindNull(i++);
			stmt.bindLong(i++, (node instanceof FileNode) ? Node.TYPE_NOTE
					: Node.TYPE_DIR);
		} else {
			stmt.bindString(i++, guid);
			stmt.bindLong(i++, (node instanceof FileNode) ? Node.TYPE_NOTE
					: Node.TYPE_BOOK);
		}
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	@Override
	public long updateSelected(Node node, boolean isSelected) {
		return updateSelected(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, isSelected);
	}

	@Override
	public long updateSelected(SQLiteDatabase db, Node node, boolean isSelected) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateSelectedNT(node, isSelected);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	@Override
	public long updateSelectedNT(Node node, boolean isSelected) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateSelectedStmt;
		stmt.bindLong(i++, isSelected ? 1 : 0);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateParent(com.yuji.ef.dao.Node, long)
	 */
	@Override
	public long updateParent(Node node, long parent) {
		return updateParent(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, parent);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#updateParent(android.database.sqlite.SQLiteDatabase
	 * , com.yuji.ef.dao.Node, long)
	 */
	@Override
	public long updateParent(SQLiteDatabase db, Node node, long parent) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateParentNT(node, parent);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateParentNT(com.yuji.ef.dao.Node, long)
	 */
	@Override
	public long updateParentNT(Node node, long parent) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateParentStmt;
		stmt.bindLong(i++, parent);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	@Override
	public long updateNoteFlag(int flag) {
		return updateNoteFlag(DatabaseHelper.getInstance().getSQLiteDatabase(),
				flag);
	}

	@Override
	public long updateNoteFlag(SQLiteDatabase db, int flag) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateNoteFlagNT(flag);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	@Override
	public long updateNoteFlagNT(int flag) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateNoteFlagStmt;
		stmt.bindLong(i++, flag);
		stmt.bindLong(i++, Node.TYPE_NOTE);
		id = stmt.executeInsert();
		return id;
	}

	@Override
	public long updateFlag(Node node, int flag) {
		return updateFlag(DatabaseHelper.getInstance().getSQLiteDatabase(),
				node, flag);
	}

	@Override
	public long updateFlag(SQLiteDatabase db, Node node, int flag) {
		long id = -1;

		db.beginTransaction();
		try {
			id = updateFlagNT(node, flag);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	@Override
	public long updateFlagNT(Node node, int flag) {
		long id = -1;
		int i = 1;

		SQLiteStatement stmt = updateFlagStmt;
		stmt.bindLong(i++, flag);
		stmt.bindLong(i++, node.getId());
		id = stmt.executeInsert();
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#updateChildren(com.yuji.ef.dao.Node,
	 * java.lang.String)
	 */
	@Override
	public long updateChildren(Node node, String children) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return updateChildren(db, node, children);
	}

	private long updateChildren(SQLiteDatabase db, Node node, String children) {
		long id = -1;
		db.beginTransaction();
		try {
			id = updateChildrenNT(node, children);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#delete(long)
	 */
	@Override
	public long delete(long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return delete(db, id);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#delete(android.database.sqlite.SQLiteDatabase,
	 * long)
	 */
	@Override
	public long delete(SQLiteDatabase db, long did) {
		long id = -1;

		db.beginTransaction();
		try {
			id = deleteNT(did);
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#deleteNT(long)
	 */
	@Override
	public long deleteNT(long did) {
		long id = -1; // TODO
		int i = 1;

		SQLiteStatement stmt = deleteIdStmt;
		stmt.bindLong(i++, did);
		stmt.execute();
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#delete()
	 */
	@Override
	public long delete() {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		return delete(db);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.yuji.ef.dao.NodeDao#delete(android.database.sqlite.SQLiteDatabase)
	 */
	@Override
	public long delete(SQLiteDatabase db) {
		long id = -1;

		db.beginTransaction();
		try {
			deleteNT();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.yuji.ef.dao.NodeDao#deleteNT()
	 */
	@Override
	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
