/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.co.frdm.Vamp.Frame1_AboutBox;
import jp.co.frdm.Vamp.PlcTable;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.VampBundle;
import jp.co.frdm.Vamp.dialog.DlgAddPlc;
import jp.co.frdm.Vamp.dialog.DlgEditPlc;
import jp.co.frdm.Vamp.emulator.AbstractPlc;
import jp.co.frdm.Vamp.emulator.PlcFactory;
import jp.co.frdm.Vamp.receiver.AbstractReceiver;
import jp.co.frdm.Vamp.receiver.ReceiverFactory;

public class Frame1
extends JFrame {
    private File workingDir;
    private final PlcTable plcTable;
    JPanel contentPane;
    JToolBar jToolBar = new JToolBar();
    JButton btnOpen = new JButton();
    JButton btnSave = new JButton();
    JButton btnHelp = new JButton();
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable1 = new JTable();
    JButton btnAdd = new JButton();
    JButton btnDel = new JButton();

    public Frame1() {
        this(new PlcTable());
    }

    public Frame1(PlcTable plcTable) {
        this.plcTable = plcTable;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.image1 = new ImageIcon(Frame1.class.getResource("/images/openFile.gif"));
        this.image2 = new ImageIcon(Frame1.class.getResource("/images/closeFile.gif"));
        this.image3 = new ImageIcon(Frame1.class.getResource("/images/help.gif"));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(400, 300));
        this.setTitle(VampBundle.getString("title"));
        this.btnOpen.setIcon(this.image1);
        this.btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame1.this.btnOpen_actionPerformed(e);
            }
        });
        this.btnOpen.setToolTipText(VampBundle.getString("open"));
        this.btnSave.setIcon(this.image2);
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame1.this.btnSave_actionPerformed(e);
            }
        });
        this.btnSave.setToolTipText(VampBundle.getString("save"));
        this.btnHelp.setIcon(this.image3);
        this.btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame1.this.btnHelp_actionPerformed(e);
            }
        });
        this.btnHelp.setToolTipText(VampBundle.getString("version"));
        this.jTable1.setCellSelectionEnabled(false);
        this.jTable1.setModel(this.plcTable);
        TableColumnModel tcm = this.jTable1.getColumnModel();
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setPreferredWidth(PlcTable.getColomnWidth(i));
        }
        this.jTable1.setRowSelectionAllowed(true);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Frame1.this.jTable1_mouseClicked(e);
            }
        });
        this.btnAdd.setText(VampBundle.getString("add"));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame1.this.btnAdd_actionPerformed(e);
            }
        });
        this.btnDel.setText(VampBundle.getString("delete"));
        this.btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame1.this.btnDel_actionPerformed(e);
            }
        });
        JButton btnProp = new JButton(VampBundle.getString("property"));
        btnProp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Frame1.this.btnProp_actionPerformed(e);
            }
        });
        this.jToolBar.add(this.btnOpen);
        this.jToolBar.add(this.btnSave);
        this.jToolBar.add(this.btnHelp);
        this.jToolBar.add((Component)this.btnAdd, null);
        this.jToolBar.add((Component)this.btnDel, null);
        this.jToolBar.add((Component)btnProp, null);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.jTable1.setSelectionMode(0);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            ReceiverFactory.allClear();
            System.exit(0);
        }
    }

    void btnHelp_actionPerformed(ActionEvent e) {
        Frame1_AboutBox dlg = new Frame1_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    void btnOpen_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        if (this.workingDir != null) {
            chooser.setCurrentDirectory(this.workingDir);
            chooser.setSelectedFile(this.workingDir);
        }
        VampFileFilter filter = new VampFileFilter();
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.workingDir = chooser.getSelectedFile();
            if (this.workingDir.isDirectory()) {
                return;
            }
            System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
            Util.loadPlcTable(this.workingDir, this.plcTable);
        }
    }

    void btnSave_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        if (this.workingDir != null) {
            chooser.setCurrentDirectory(this.workingDir);
            chooser.setSelectedFile(this.workingDir);
        }
        VampFileFilter filter = new VampFileFilter();
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.workingDir = chooser.getSelectedFile();
            if (this.workingDir.isDirectory()) {
                return;
            }
            System.out.println("You chose to sava this file: " + chooser.getSelectedFile().getName());
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.workingDir));
                for (int i = 0; i < this.plcTable.getRowCount(); ++i) {
                    out.writeObject(this.plcTable.getPlc(i));
                }
                out.flush();
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showConfirmDialog(null, VampBundle.getString("write_file_err"), VampBundle.getString("err"), -1);
            }
        }
    }

    void btnAdd_actionPerformed(ActionEvent e) {
        DlgAddPlc dlg = new DlgAddPlc((Frame)this, this.plcTable.getRowCount());
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.setVisible(true);
        String params = dlg.getPlcParams();
        System.out.println(params);
        if (params != null) {
            try {
                AbstractPlc plc = PlcFactory.createPlc(params);
                this.plcTable.addPlc(plc);
                AbstractReceiver receiver = ReceiverFactory.getReceiver(plc.getPortNo());
                receiver.addRecvListener(plc);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showConfirmDialog(null, VampBundle.getString("not_make_plc"), VampBundle.getString("err"), -1);
            }
        }
    }

    void btnDel_actionPerformed(ActionEvent e) {
        AbstractPlc plc = this.plcTable.getPlc(this.jTable1.getSelectedRow());
        if (plc == null) {
            return;
        }
        if (0 != JOptionPane.showConfirmDialog(null, VampBundle.getString("plc_delete_msg"), VampBundle.getString("delete"), 0)) {
            return;
        }
        this.plcTable.removePlc(plc);
        AbstractReceiver receiver = ReceiverFactory.getReceiver(plc.getPortNo());
        receiver.removeRecvListener(plc);
        if (this.plcTable.getRowCount() <= 0) {
            ReceiverFactory.allClear();
        }
    }

    void btnProp_actionPerformed(ActionEvent e) {
        AbstractPlc plc = this.plcTable.getPlc(this.jTable1.getSelectedRow());
        if (plc == null) {
            return;
        }
        DlgEditPlc dlg = new DlgEditPlc((Frame)this, plc);
        dlg.setTitle(plc.getName() + " : " + plc.getPlcInfo());
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    void jTable1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.btnProp_actionPerformed(null);
    }

    private static class VampFileFilter
    extends FileFilter {
        private static final String extension = ".vmp";
        private static final String description = VampBundle.getString("vamp_file");

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            if (name.length() < 4) {
                return false;
            }
            return extension.equals(name.substring(name.length() - 4));
        }

        public String getDescription() {
            return description;
        }
    }
}

