/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator.converter;

import java.io.Serializable;
import jp.co.frdm.Vamp.Util;

public class SNGW
implements Serializable {
    private static final byte[] TOCHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private byte btNetNo;
    private byte btNodeNo;
    private byte btUnitNo;
    private byte[] recvBuffer;
    private byte[] sendBuffer;

    public SNGW(int netNo, int nodeNo, int unitNo) {
        this.btNetNo = (byte)netNo;
        this.btNodeNo = (byte)nodeNo;
        this.btUnitNo = (byte)unitNo;
    }

    public String getInfo() {
        return Integer.toString(this.btNetNo & 0xFF) + "." + Integer.toString(this.btNodeNo & 0xFF) + "." + Integer.toString(this.btUnitNo & 0xFF);
    }

    public String getParam() {
        return Integer.toString(this.btNetNo & 0xFF) + "\t" + Integer.toString(this.btNodeNo & 0xFF);
    }

    public boolean checkCommand(byte[] data) {
        if (data.length < 13) {
            return false;
        }
        if (35 != data[0] || 48 != data[1] || 48 != data[2] || 48 != data[3] || 48 != data[4] || 48 != data[5] || 48 != data[6] || this.btNodeNo != data[12]) {
            return false;
        }
        this.recvBuffer = data;
        return true;
    }

    public int getCommandKind() {
        return Util.toByteArray(this.recvBuffer, 13, 2)[0];
    }

    public int getMemoryKind() {
        return Util.toByteArray(this.recvBuffer, 13, 2)[0];
    }

    public int getMemoryAdder() {
        byte[] addr = Util.toByteArray(this.recvBuffer, 15, 4);
        return (addr[0] & 0xFF) << 8 | addr[1] & 0xFF;
    }

    public int getWordLength() {
        byte[] word = Util.toByteArray(this.recvBuffer, 19, 4);
        return (word[0] & 0xFF) << 8 | word[1] & 0xFF;
    }

    public byte[] getData() {
        if (this.recvBuffer.length <= 19) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Util.toByteArray(this.recvBuffer, 19, this.recvBuffer.length - 20);
    }

    public byte[] getErrorResponse(int errCode) {
        byte[] sendData = this.createSendBuff(18);
        sendData[15] = TOCHAR[errCode >> 4 & 0xF];
        sendData[16] = TOCHAR[errCode & 0xF];
        byte bcc = 0;
        for (int i = 1; i < sendData.length - 1; ++i) {
            bcc = (byte)(bcc ^ sendData[i]);
        }
        sendData[sendData.length - 1] = bcc;
        return sendData;
    }

    public byte[] getResponse(byte[] data) {
        byte[] sendData = this.createSendBuff(18 + data.length * 2);
        int dpos = 17;
        for (int spos = 0; spos < data.length; ++spos) {
            sendData[dpos++] = TOCHAR[data[spos] >> 4 & 0xF];
            sendData[dpos++] = TOCHAR[data[spos] & 0xF];
        }
        byte bcc = 0;
        for (int i = 1; i < sendData.length - 1; ++i) {
            bcc = (byte)(bcc ^ sendData[i]);
        }
        sendData[sendData.length - 1] = bcc;
        return sendData;
    }

    private byte[] createSendBuff(int len) {
        if (len < 18) {
            len = 18;
        }
        this.sendBuffer = new byte[len];
        this.sendBuffer[0] = 35;
        this.sendBuffer[1] = 49;
        this.sendBuffer[2] = 48;
        this.sendBuffer[3] = 48;
        this.sendBuffer[4] = 48;
        this.sendBuffer[5] = 48;
        this.sendBuffer[6] = 48;
        int slen = len - 12;
        this.sendBuffer[7] = TOCHAR[slen >> 12 & 0xF];
        this.sendBuffer[8] = TOCHAR[slen >> 8 & 0xF];
        this.sendBuffer[9] = TOCHAR[slen >> 4 & 0xF];
        this.sendBuffer[10] = TOCHAR[slen & 0xF];
        this.sendBuffer[11] = this.recvBuffer[11];
        this.sendBuffer[12] = this.recvBuffer[12];
        this.sendBuffer[13] = this.recvBuffer[13];
        this.sendBuffer[14] = this.recvBuffer[14];
        this.sendBuffer[15] = 48;
        this.sendBuffer[16] = 48;
        byte bcc = 0;
        for (int i = 1; i < this.sendBuffer.length - 1; ++i) {
            bcc = (byte)(bcc ^ this.sendBuffer[i]);
        }
        this.sendBuffer[this.sendBuffer.length - 1] = bcc;
        return this.sendBuffer;
    }

    private byte toBcd(int data) {
        return (byte)(data / 10 * 16 + data % 10);
    }

    private int toBin(byte data) {
        return data / 16 * 10 + data % 16;
    }

    public byte[] getRecvData() {
        return this.recvBuffer;
    }

    public byte[] getSendData() {
        return this.sendBuffer;
    }
}

