/*
 * Decompiled with CFR 0.152.
 */
package program;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.emulator.PlcControl;
import program.PlcRunnable;

public class MultiLogg3
implements PlcRunnable {
    private NumberFormat fmt = new DecimalFormat("0000");
    private long nextTime;

    public void startUpCall(PlcControl plc) throws Exception {
        this.nextTime = this.getNextMinute(plc);
        Calendar cal = (Calendar)plc.getPlcTime().clone();
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(12, -1);
        this.set3SecDatas(plc, cal);
    }

    public void cycleCall(PlcControl plc) throws Exception {
        if (this.nextTime <= System.currentTimeMillis()) {
            this.nextTime = this.getNextMinute(plc);
            Calendar cal = (Calendar)plc.getPlcTime().clone();
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(12, -1);
            this.set3SecDatas(plc, cal);
        }
    }

    private long getNextMinute(PlcControl plc) {
        Calendar cal = (Calendar)plc.getPlcTime().clone();
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(12, 1);
        return cal.getTimeInMillis();
    }

    private void set3SecDatas(PlcControl plc, Calendar cal) {
        for (int i = 0; i < 20; ++i) {
            int top = 10000 + 44 * i;
            plc.writePlcMem("DM", top, this.dateToBcd(cal));
            plc.writePlcMem("DM", top + 4, Util.toByteArrey(this.fmt.format(i + 1)));
            for (int j = 1; j < 40; ++j) {
                plc.writePlcMem("DM", top + 4 + j, Util.toByteArrey(this.fmt.format(j + 1)));
            }
            cal.add(13, 3);
        }
    }

    private byte[] dateToBcd(Calendar cal) {
        byte[] ret = new byte[8];
        int src = cal.get(1);
        ret[0] = this.toBcd(src / 100);
        ret[1] = this.toBcd(src % 100);
        ret[2] = this.toBcd(cal.get(2) + 1);
        ret[3] = this.toBcd(cal.get(5));
        ret[4] = this.toBcd(cal.get(7));
        ret[5] = this.toBcd(cal.get(11));
        ret[6] = this.toBcd(cal.get(12));
        ret[7] = this.toBcd(cal.get(13));
        return ret;
    }

    private byte toBcd(int src) {
        return (byte)((src %= 100) / 10 * 16 + src % 10);
    }
}

