/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.design;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRExpressionChunk;
import dori.jasper.engine.JRField;
import dori.jasper.engine.JRParameter;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.design.JasperDesign;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JRClassGenerator {
    private JasperDesign jasperDesign = null;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;

    protected JRClassGenerator(JasperDesign jrDesign) {
        this.jasperDesign = jrDesign;
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }

    public static String generateClass(JasperDesign jrDesign) throws JRException {
        JRClassGenerator generator = new JRClassGenerator(jrDesign);
        return generator.generateClass();
    }

    protected String generateClass() throws JRException {
        Iterator it;
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("/*\n * Generated by JasperReports - " + new SimpleDateFormat().format(new Date()) + "\n" + " */\n" + "import dori.jasper.engine.*;\n" + "import dori.jasper.engine.fill.*;\n" + "\n" + "import java.util.*;\n" + "import java.math.*;\n" + "import java.text.*;\n" + "import java.io.*;\n" + "import java.net.*;\n" + "\n" + "\n" + "/**\n" + " *\n" + " */\n" + "public class " + this.jasperDesign.getName() + " extends JRCalculator\n" + "{\n" + "\n" + "\n" + "    /**\n" + "     *\n" + "     */\n");
        Map parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            Iterator it2 = parameterNames.iterator();
            while (it2.hasNext()) {
                sbuffer.append("    private JRFillParameter parameter_" + it2.next() + " = null;\n");
            }
        }
        sbuffer.append("\n");
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            Iterator it3 = fieldNames.iterator();
            while (it3.hasNext()) {
                sbuffer.append("    private JRFillField field_" + it3.next() + " = null;\n");
            }
        }
        sbuffer.append("\n");
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            int i = 0;
            while (i < variables.length) {
                sbuffer.append("    private JRFillVariable variable_" + variables[i].getName() + " = null;\n");
                ++i;
            }
        }
        sbuffer.append("\n\n    /**\n     *\n     */\n    public void customizedInit(\n        Map pm,\n        Map fm,\n        Map vm\n        ) throws JRException\n    {\n");
        parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            String parameterName = null;
            it = parameterNames.iterator();
            while (it.hasNext()) {
                parameterName = (String)it.next();
                sbuffer.append("        parameter_" + parameterName + " = (JRFillParameter)parsm.get(\"" + parameterName + "\");\n");
            }
        }
        sbuffer.append("\n");
        fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            String fieldName = null;
            it = fieldNames.iterator();
            while (it.hasNext()) {
                fieldName = (String)it.next();
                sbuffer.append("        field_" + fieldName + " = (JRFillField)fldsm.get(\"" + fieldName + "\");\n");
            }
        }
        sbuffer.append("\n");
        variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            String variableName = null;
            int i = 0;
            while (i < variables.length) {
                variableName = variables[i].getName();
                sbuffer.append("        variable_" + variableName + " = (JRFillVariable)varsm.get(\"" + variableName + "\");\n");
                ++i;
            }
        }
        sbuffer.append("    }\n\n\n    /**\n     * Test method\n     */\n    public static void helloJasper()\n    {\n        System.out.println(\"------------------------------\");\n        System.out.println(\" Hello, Jasper!...\");\n        System.out.println(\"------------------------------\");\n    }\n\n\n");
        sbuffer.append(this.generateMethod((byte)3));
        sbuffer.append(this.generateMethod((byte)1));
        sbuffer.append(this.generateMethod((byte)2));
        sbuffer.append("}\n");
        return sbuffer.toString();
    }

    private String generateMethod(byte evaluationType) throws JRException {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("    /**\n     *\n     */\n    public Object evaluate" + (String)methodSuffixMap.get(new Byte(evaluationType)) + "(int id) throws Throwable\n" + "    {\n" + "        Object value = null;\n" + "\n" + "        switch (id)\n" + "        {\n");
        Collection expressions = this.jasperDesign.getExpressions();
        if (expressions != null && expressions.size() > 0) {
            JRExpression expression = null;
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                expression = (JRExpression)it.next();
                sbuffer.append("            case " + expression.getId() + " : // " + expression.getName() + "\n" + "            {\n" + "                value = (" + expression.getValueClassName() + ")(");
                sbuffer.append(this.generateExpression(expression, evaluationType));
                sbuffer.append(");\n                break;\n            }\n");
            }
        }
        sbuffer.append("           default :\n           {\n           }\n        }\n        \n        return value;\n    }\n\n\n");
        return sbuffer.toString();
    }

    private String generateExpression(JRExpression expression, byte evaluationType) throws JRException {
        Map parametersMap = this.jasperDesign.getParametersMap();
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        Map variablesMap = this.jasperDesign.getVariablesMap();
        JRParameter jrParameter = null;
        JRField jrField = null;
        JRVariable jrVariable = null;
        StringBuffer sbuffer = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            int i = 0;
            while (i < chunks.length) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sbuffer.append(chunkText);
                        break;
                    }
                    case 2: {
                        jrParameter = (JRParameter)parametersMap.get(chunkText);
                        sbuffer.append("((" + jrParameter.getValueClassName() + ")" + "parameter_" + chunkText + ".getValue()" + ")");
                        break;
                    }
                    case 3: {
                        jrField = (JRField)fieldsMap.get(chunkText);
                        sbuffer.append("((" + jrField.getValueClassName() + ")" + "field_" + chunkText + ".get" + (String)fieldPrefixMap.get(new Byte(evaluationType)) + "Value()" + ")");
                        break;
                    }
                    case 4: {
                        jrVariable = (JRVariable)variablesMap.get(chunkText);
                        sbuffer.append("((" + jrVariable.getValueClassName() + ")" + "variable_" + chunkText + ".get" + (String)variablePrefixMap.get(new Byte(evaluationType)) + "Value()" + ")");
                    }
                }
                ++i;
            }
        }
        if (sbuffer.length() == 0) {
            sbuffer.append("null");
        }
        return sbuffer.toString();
    }
}

