/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.fill.JRComparableIncrementerFactory;
import dori.jasper.engine.fill.JRDefaultIncrementerFactory;
import dori.jasper.engine.fill.JRFloatAverageIncrementer;
import dori.jasper.engine.fill.JRFloatCountIncrementer;
import dori.jasper.engine.fill.JRFloatStandardDeviationIncrementer;
import dori.jasper.engine.fill.JRFloatSumIncrementer;
import dori.jasper.engine.fill.JRFloatVarianceIncrementer;
import dori.jasper.engine.fill.JRIncrementer;
import dori.jasper.engine.fill.JRIncrementerFactory;

public class JRFloatIncrementerFactory
implements JRIncrementerFactory {
    protected static final Float ZERO = new Float(0.0f);
    private static JRFloatIncrementerFactory mainInstance = new JRFloatIncrementerFactory();

    private JRFloatIncrementerFactory() {
    }

    public static JRFloatIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRFloatCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRFloatSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRFloatAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRFloatStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRFloatVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

