/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.util;

import dori.jasper.engine.JRException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class JRLoader {
    static /* synthetic */ Class class$dori$jasper$engine$util$JRLoader;

    public static Object loadObject(String fileName) throws JRException {
        return JRLoader.loadObject(new File(fileName));
    }

    public static Object loadObject(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        Object obj = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from file : " + file, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from file : " + file, e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return obj;
    }

    public static Object loadObject(URL url) throws JRException {
        Object obj = null;
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = url.openStream();
            ois = new ObjectInputStream(is);
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from URL : " + url, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from URL : " + url, e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object loadObject(InputStream is) throws JRException {
        Object obj = null;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(is);
                obj = ois.readObject();
            }
            catch (IOException e) {
                throw new JRException("Error loading object from InputStream", e);
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Class not found when loading object from InputStream", e);
            }
            Object var6_3 = null;
            if (ois == null) return obj;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ois.close();
        return obj;
    }

    public static Object loadObjectFromLocation(String location) throws JRException {
        try {
            URL url = new URL(location);
            return JRLoader.loadObject(url);
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists() && file.isFile()) {
                return JRLoader.loadObject(file);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(location);
            if (url == null) {
                classLoader = (class$dori$jasper$engine$util$JRLoader == null ? (class$dori$jasper$engine$util$JRLoader = JRLoader.class$("dori.jasper.engine.util.JRLoader")) : class$dori$jasper$engine$util$JRLoader).getClassLoader();
                url = classLoader.getResource(location);
            }
            if (url != null) {
                return JRLoader.loadObject(url);
            }
            throw new JRException("Could not load object from location : " + location);
        }
    }

    public static byte[] loadBytes(File file) throws JRException {
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = fis.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data : " + file, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(URL url) throws JRException {
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = url.openStream();
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data : " + url, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadBytes(InputStream is) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            try {
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[10000];
                int ln = 0;
                while (true) {
                    if ((ln = is.read(bytes)) <= 0) {
                        baos.flush();
                        break;
                    }
                    baos.write(bytes, 0, ln);
                }
            }
            catch (IOException e) {
                throw new JRException("Error loading byte data from input stream.", e);
            }
            Object var5_5 = null;
            if (baos == null) return baos.toByteArray();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (baos == null) throw throwable;
            try {
                baos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        baos.close();
        return baos.toByteArray();
    }

    public static byte[] loadBytesFromLocation(String location) throws JRException {
        try {
            URL url = new URL(location);
            return JRLoader.loadBytes(url);
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists() && file.isFile()) {
                return JRLoader.loadBytes(file);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL url = classLoader.getResource(location);
            if (url == null) {
                classLoader = (class$dori$jasper$engine$util$JRLoader == null ? (class$dori$jasper$engine$util$JRLoader = JRLoader.class$("dori.jasper.engine.util.JRLoader")) : class$dori$jasper$engine$util$JRLoader).getClassLoader();
                url = classLoader.getResource(location);
            }
            if (url != null) {
                return JRLoader.loadBytes(url);
            }
            throw new JRException("Byte data not found at location : " + location);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

