/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            if (pdfPRow.cells[i] == null) continue;
            this.cells[i] = new PdfPCell(pdfPRow.cells[i]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f = 0.0f;
        this.calculated = false;
        for (int i = 0; i < fArray.length; ++i) {
            PdfPCell pdfPCell = this.cells[i];
            pdfPCell.setLeft(f);
            int n = i + pdfPCell.getColspan();
            while (i < n) {
                f += fArray[i];
                ++i;
            }
            --i;
            pdfPCell.setRight(f);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i = 0; i < this.cells.length; ++i) {
            float f;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            PdfPTable pdfPTable = pdfPCell.getTable();
            Image image = pdfPCell.getImage();
            if (image != null) {
                image.scalePercent(100.0f);
                f = (pdfPCell.right() - pdfPCell.getPaddingRight() - pdfPCell.getPaddingLeft() - pdfPCell.left()) / image.scaledWidth();
                image.scalePercent(f * 100.0f);
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getPaddingTop() - pdfPCell.getPaddingBottom() - image.scaledHeight());
            } else if (pdfPTable == null) {
                f = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getPaddingRight();
                ColumnText columnText = new ColumnText(null);
                columnText.setSimpleColumn(pdfPCell.getPhrase(), pdfPCell.left() + pdfPCell.getPaddingLeft(), pdfPCell.top() - pdfPCell.getPaddingTop(), f, -20000.0f, 0.0f, pdfPCell.getHorizontalAlignment());
                columnText.setLeading(pdfPCell.getLeading(), pdfPCell.getMultipliedLeading());
                columnText.setIndent(pdfPCell.getIndent());
                columnText.setExtraParagraphSpace(pdfPCell.getExtraParagraphSpace());
                columnText.setFollowingIndent(pdfPCell.getFollowingIndent());
                columnText.setRightIndent(pdfPCell.getRightIndent());
                columnText.setRunDirection(pdfPCell.getRunDirection());
                columnText.setArabicOptions(pdfPCell.getArabicOptions());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f2 = columnText.getYLine();
                if (pdfPCell.isUseDescender()) {
                    f2 += columnText.getDescender();
                }
                pdfPCell.setBottom(f2 - pdfPCell.getPaddingBottom());
            } else {
                pdfPTable.setTotalWidth(pdfPCell.right() - pdfPCell.getPaddingRight() - pdfPCell.getPaddingLeft() - pdfPCell.left());
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getPaddingTop() - pdfPCell.getPaddingBottom() - pdfPTable.getTotalHeight());
            }
            f = pdfPCell.getFixedHeight();
            if (f <= 0.0f) {
                f = pdfPCell.height();
            }
            if (f < pdfPCell.getFixedHeight()) {
                f = pdfPCell.getFixedHeight();
            } else if (f < pdfPCell.getMinimumHeight()) {
                f = pdfPCell.getMinimumHeight();
            }
            if (!(f > this.maxHeight)) continue;
            this.maxHeight = f;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackgroung(float f, float f2, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[2];
        PdfContentByte pdfContentByte2 = pdfContentByteArray[1];
        float f3 = pdfPCell.left() + f;
        float f4 = pdfPCell.top() + f2;
        float f5 = pdfPCell.right() + f;
        float f6 = f4 - this.maxHeight;
        Color color = pdfPCell.backgroundColor();
        if (color != null) {
            pdfContentByte2.setColorFill(color);
            pdfContentByte2.rectangle(f3, f6, f5 - f3, f4 - f6);
            pdfContentByte2.fill();
        } else if (pdfPCell.grayFill() > 0.0f) {
            pdfContentByte2.setGrayFill(pdfPCell.grayFill());
            pdfContentByte2.rectangle(f3, f6, f5 - f3, f4 - f6);
            pdfContentByte2.fill();
        }
        if (pdfPCell.hasBorders()) {
            Color color2;
            if (pdfPCell.borderWidth() != -1.0f) {
                pdfContentByte.setLineWidth(pdfPCell.borderWidth());
            }
            if ((color2 = pdfPCell.borderColor()) != null) {
                pdfContentByte.setColorStroke(color2);
            }
            if (pdfPCell.hasBorder(15)) {
                pdfContentByte.rectangle(f3, f6, f5 - f3, f4 - f6);
            } else {
                if (pdfPCell.hasBorder(8)) {
                    pdfContentByte.moveTo(f5, f6);
                    pdfContentByte.lineTo(f5, f4);
                }
                if (pdfPCell.hasBorder(4)) {
                    pdfContentByte.moveTo(f3, f6);
                    pdfContentByte.lineTo(f3, f4);
                }
                if (pdfPCell.hasBorder(2)) {
                    pdfContentByte.moveTo(f3, f6);
                    pdfContentByte.lineTo(f5, f6);
                }
                if (pdfPCell.hasBorder(1)) {
                    pdfContentByte.moveTo(f3, f4);
                    pdfContentByte.lineTo(f5, f4);
                }
            }
            pdfContentByte.stroke();
            if (color2 != null) {
                pdfContentByte.resetRGBColorStroke();
            }
        }
    }

    public void writeCells(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        int n3;
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (n2 < 0) {
            n2 = this.cells.length;
        }
        n2 = Math.min(n2, this.cells.length);
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            return;
        }
        for (n3 = n; n3 >= 0 && this.cells[n3] == null; --n3) {
            f -= this.widths[n3 - 1];
        }
        f -= this.cells[n3].left();
        for (int i = n3; i < n2; ++i) {
            float f3;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            this.writeBorderAndBackgroung(f, f2, pdfPCell, pdfContentByteArray);
            PdfPTable pdfPTable = pdfPCell.getTable();
            Image image = pdfPCell.getImage();
            float f4 = 0.0f;
            boolean bl = false;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f4 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.height() - pdfPCell.getPaddingTop();
                    break;
                }
                case 5: {
                    f4 = pdfPCell.top() + f2 + (pdfPCell.height() - this.maxHeight) / 2.0f - pdfPCell.getPaddingTop();
                    break;
                }
                default: {
                    bl = true;
                    f4 = pdfPCell.top() + f2 - pdfPCell.getPaddingTop();
                }
            }
            if (image != null) {
                boolean bl2 = false;
                if (pdfPCell.height() > this.maxHeight) {
                    image.scalePercent(100.0f);
                    f3 = (this.maxHeight - pdfPCell.getPaddingTop() - pdfPCell.getPaddingBottom()) / image.scaledHeight();
                    image.scalePercent(f3 * 100.0f);
                    bl2 = true;
                }
                f3 = pdfPCell.left() + f + pdfPCell.getPaddingLeft();
                if (bl2) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f3 = f + (pdfPCell.left() + pdfPCell.getPaddingLeft() + pdfPCell.right() - pdfPCell.getPaddingRight() - image.scaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f3 = f + pdfPCell.right() - pdfPCell.getPaddingRight() - image.scaledWidth();
                            break;
                        }
                    }
                    f4 = pdfPCell.top() + f2 - pdfPCell.getPaddingTop();
                }
                image.setAbsolutePosition(f3, f4 - image.scaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            } else if (pdfPTable == null) {
                float f5 = pdfPCell.getFixedHeight();
                f3 = pdfPCell.right() + f - pdfPCell.getPaddingRight();
                float f6 = pdfPCell.left() + f + pdfPCell.getPaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f3 += 10000.0f;
                            f6 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            f6 -= 20000.0f;
                            break;
                        }
                        default: {
                            f3 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = new ColumnText(pdfContentByteArray[3]);
                float f7 = -20000.0f;
                if (f5 > 0.0f && pdfPCell.height() > this.maxHeight) {
                    f4 = pdfPCell.top() + f2 - pdfPCell.getPaddingTop();
                    f7 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.getPaddingBottom();
                }
                columnText.setSimpleColumn(pdfPCell.getPhrase(), f6, f4, f3, f7, 0.0f, pdfPCell.getHorizontalAlignment());
                columnText.setLeading(pdfPCell.getLeading(), pdfPCell.getMultipliedLeading());
                columnText.setIndent(pdfPCell.getIndent());
                columnText.setExtraParagraphSpace(pdfPCell.getExtraParagraphSpace());
                columnText.setFollowingIndent(pdfPCell.getFollowingIndent());
                columnText.setRightIndent(pdfPCell.getRightIndent());
                columnText.setSpaceCharRatio(pdfPCell.getSpaceCharRatio());
                columnText.setRunDirection(pdfPCell.getRunDirection());
                columnText.setArabicOptions(pdfPCell.getArabicOptions());
                try {
                    columnText.go();
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            } else {
                float f8 = 0.0f;
                f3 = 0.0f;
                if (bl && pdfPTable.size() > 0) {
                    PdfPRow pdfPRow = pdfPTable.getRow(pdfPTable.size() - 1);
                    f8 = this.maxHeight - pdfPTable.getTotalHeight() - pdfPCell.getPaddingBottom() - pdfPCell.getPaddingTop();
                    if (f8 > 0.0f) {
                        f3 = pdfPRow.getMaxHeights();
                        pdfPRow.setMaxHeights(pdfPRow.getMaxHeights() + f8);
                    }
                }
                pdfPTable.writeSelectedRows(0, -1, pdfPCell.left() + f + pdfPCell.getPaddingLeft(), f4, pdfContentByteArray);
                if (bl && f8 > 0.0f) {
                    pdfPTable.getRow(pdfPTable.size() - 1).setMaxHeights(f3);
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.left() + f, pdfPCell.top() + f2 - this.maxHeight, pdfPCell.right() + f, pdfPCell.top() + f2);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f) {
        this.maxHeight = f;
    }

    float[] getEventWidth(float f) {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        float[] fArray = new float[n + 1];
        n = 0;
        fArray[n++] = f;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            fArray[n] = fArray[n - 1] + this.cells[i].width();
            ++n;
        }
        return fArray;
    }
}

