/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.PropertyNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.CaseInsensitiveMap;

public class DtoMetaDataImpl
implements DtoMetaData {
    private Class beanClass;
    private CaseInsensitiveMap propertyTypes = new CaseInsensitiveMap();
    protected BeanAnnotationReader beanAnnotationReader;
    private ValueTypeFactory valueTypeFactory;

    public DtoMetaDataImpl() {
    }

    public DtoMetaDataImpl(Class beanClass, BeanAnnotationReader beanAnnotationReader) {
        this.setBeanClass(beanClass);
        this.setBeanAnnotationReader(beanAnnotationReader);
        this.initialize();
    }

    public void initialize() {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)this.getBeanClass());
        this.setupPropertyType(beanDesc);
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public int getPropertyTypeSize() {
        return this.propertyTypes.size();
    }

    public PropertyType getPropertyType(int index) {
        return (PropertyType)this.propertyTypes.get(index);
    }

    public PropertyType getPropertyType(String propertyName) throws PropertyNotFoundRuntimeException {
        PropertyType propertyType = (PropertyType)this.propertyTypes.get((Object)propertyName);
        if (propertyType == null) {
            throw new PropertyNotFoundRuntimeException(this.beanClass, propertyName);
        }
        return propertyType;
    }

    public boolean hasPropertyType(String propertyName) {
        return this.propertyTypes.get((Object)propertyName) != null;
    }

    protected void setupPropertyType(BeanDesc beanDesc) {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            PropertyType pt = this.createPropertyType(beanDesc, pd);
            this.addPropertyType(pt);
        }
    }

    protected PropertyType createPropertyType(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        String columnName = this.getColumnName(propertyDesc);
        ValueType valueType = this.getValueType(propertyDesc);
        PropertyTypeImpl pt = new PropertyTypeImpl(propertyDesc, valueType, columnName);
        return pt;
    }

    private String getColumnName(PropertyDesc propertyDesc) {
        String ca = this.beanAnnotationReader.getColumnAnnotation(propertyDesc);
        if (ca != null) {
            return ca;
        }
        return propertyDesc.getPropertyName();
    }

    protected ValueType getValueType(PropertyDesc propertyDesc) {
        String valueTypeName = this.beanAnnotationReader.getValueType(propertyDesc);
        if (valueTypeName != null) {
            return this.getValueTypeFactory().getValueTypeByName(valueTypeName);
        }
        return this.getValueTypeFactory().getValueTypeByClass(propertyDesc.getPropertyType());
    }

    protected void addPropertyType(PropertyType propertyType) {
        this.propertyTypes.put((Object)propertyType.getPropertyName(), (Object)propertyType);
    }

    public void setBeanAnnotationReader(BeanAnnotationReader beanAnnotationReader) {
        this.beanAnnotationReader = beanAnnotationReader;
    }

    protected ValueTypeFactory getValueTypeFactory() {
        return this.valueTypeFactory;
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }
}

