/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/applet/graph/DefaultGraphPropertyModel.java,v 1.16.2.7 2007/07/11 07:47:18 frdm Exp $
 * $Revision: 1.16.2.7 $
 * $Date: 2007/07/11 07:47:18 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * ftHg GraphPropertyModel NXłB
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class DefaultGraphPropertyModel extends AbstractGraphPropertyModel {
	/** cXP[̖ڐ̐ */
	private int verticalScaleCount;
	/** cXP[̖ڐ̃sNZ */
	private int verticalScaleHeight;
	/** XP[̖ڐ̐ */
	private int horizontalScaleCount;
	/** XP[̖ڐ̎ԁi_bj */
	private long horizontalScaleWidth;
	/** Otr[ȊOR|[lg̗]̃CZbc */
	private Insets insets;
	/** Otr[R|[lg̗]̃CZbc */
	private Insets graphiViewInsets;
	/** OtE} Color IuWFNg̔z */
	private Color[] colors;
	/** ݈ʒuÂĂO[v */
	private int group;
	/** ݈ʒuÂĂnh[CfbNXigpnh[CfbNXj */
	private int handlerIndex;
	/** ݒ肳Ănh[ */
	private String[] handlerName;
	/** ܂Ԃ */
	private int foldCount;
	/** ݃NbNĂ̎QƓ */
	private Timestamp referenceTime;
	/** \Ot̉sNZ */
	private int horizontalPixcelWidth;
	/** XXP[̖ڐ蕝 */
	private int scaleOneHeightPixel;
	/** Qƕ\̕F */
	private Color explanatoryColor;
	/** Qƕ\̃tHg */
	private Font explanatoryFont;
	/**  1iڂ̓tH[}bg */
	private String firstFormat;
	/**  2iڂ̓tH[}bg */
	private String secondFormat;
	/** cXP[̃vpeB[ */
	private VerticallyScaleProperty verticallyScaleProperty;

	/**
	 * SO[ṽV[YvpeBEXg
	 * ̃Xgɂ́AGraphSeriesProperty i[Ă܂B
	 */
	private List seriesPropertyList;

	/**
	 * RXgN^
	 */
	public DefaultGraphPropertyModel(
			int verticalScaleCount,
			int verticalScaleHeight,
			int horizontalScaleCount,
			long horizontalScaleWidth,
			Insets insets,
			Insets graphiViewInsets,
			Color[] colors,
			String[] handlerName,
			int foldCount,
			int horizontalPixcelWidth,
			int scaleOneHeightPixel,
			Color explanatoryColor,
			Font explanatoryFont,
			String firstFormat,
			String secondFormat,
			VerticallyScaleProperty verticallyScaleProperty
			) {

		super();
		
		this.verticalScaleCount = verticalScaleCount;
		this.verticalScaleHeight = verticalScaleHeight;
		this.horizontalScaleCount = horizontalScaleCount;
		this.horizontalScaleWidth = horizontalScaleWidth;
		this.insets = insets;
		this.graphiViewInsets = graphiViewInsets;
		this.colors = colors;
		this.handlerName = handlerName;
		this.foldCount = foldCount;
		this.horizontalPixcelWidth = horizontalPixcelWidth;
		this.scaleOneHeightPixel = scaleOneHeightPixel;
		if (explanatoryColor == null) {
			this.explanatoryColor = Color.BLACK;
		} else {
			this.explanatoryColor = explanatoryColor;
		}
		if (explanatoryFont == null) {
			this.explanatoryFont = new Font("dialog", Font.BOLD, 14);
		} else {
			this.explanatoryFont = explanatoryFont;
		}
		this.firstFormat = firstFormat;
		this.secondFormat = secondFormat;
		this.verticallyScaleProperty = verticallyScaleProperty; 
		
		seriesPropertyList = new ArrayList();
	}

	/**
	 * CX^XfB[vRs[܂B
	 * @return GraphPropertyModel fB[vRs[ꂽCX^XB
	 */
	public GraphPropertyModel deepCopy() {
		return new DefaultGraphPropertyModel(this);
	}

	/**
	 * Rs[RXgN^
	 * @param src \[XIuWFNg
	 */
	private DefaultGraphPropertyModel(DefaultGraphPropertyModel src) {
		super();
		group = src.group;
		handlerIndex = src.handlerIndex;
		verticalScaleCount = src.verticalScaleCount;
		verticalScaleHeight = src.verticalScaleHeight;
		horizontalScaleCount = src.horizontalScaleCount;
		horizontalScaleWidth = src.horizontalScaleWidth;
		insets =
			new Insets(
				src.insets.top,
				src.insets.left,
				src.insets.bottom,
				src.insets.right);
		graphiViewInsets =
			new Insets(
				src.graphiViewInsets.top,
				src.graphiViewInsets.left,
				src.graphiViewInsets.bottom,
				src.graphiViewInsets.right);
		colors = new Color[src.colors.length];
		System.arraycopy(src.colors, 0, colors, 0, colors.length);
		handlerName = new String[src.handlerName.length];
		System.arraycopy(src.handlerName, 0, handlerName, 0, handlerName.length);

		seriesPropertyList = new ArrayList(src.seriesPropertyList.size());
		for (Iterator i = src.seriesPropertyList.iterator(); i.hasNext();) {
			GraphSeriesProperty item = (GraphSeriesProperty) i.next();
			seriesPropertyList.add(new GraphSeriesProperty(item));
		}
		foldCount = src.foldCount;
		referenceTime = src.referenceTime;
		horizontalPixcelWidth = src.horizontalPixcelWidth;
		scaleOneHeightPixel = src.scaleOneHeightPixel;
		explanatoryColor = src.explanatoryColor;
		explanatoryFont = src.explanatoryFont;
		firstFormat = src.firstFormat;
		secondFormat = src.secondFormat;
		verticallyScaleProperty = src.verticallyScaleProperty;
	}

	/**
	 * cXP[̖ڐ̐Ԃ܂B
	 * @return cXP[̖ڐ̐
	 */
	public int getVerticalScaleCount() {
		return verticalScaleCount;
	}

	/**
	 * cXP[̖ڐ̃sNZԂ܂B
	 * @return cXP[̖ڐ̃sNZ
	 */
	public int getVerticalScaleHeight() {
		return verticalScaleHeight;
	}

	/**
	 * XP[̖ڐ̐Ԃ܂B
	 * @return XP[̖ڐ̐
	 */
	public int getHorizontalScaleCount() {
		return horizontalScaleCount;
	}

	/**
	 * XP[̖ڐ̎ԁi_bjԂ܂B
	 * @return XP[̖ڐ̎ԁi_bj
	 */
	public long getHorizontalScaleWidth() {
		return horizontalScaleWidth;
	}

	/**
	 * XP[̖ڐ̐ݒ肵܂B
	 * @param horizontalScaleCount XP[̖ڐ̐
	 */
	public void setHorizontalScaleCount(int horizontalScaleCount) {
		Object old = deepCopy();
		this.horizontalScaleCount = horizontalScaleCount;
		firePropertyChange(X_SCALE_CHANGE_EVENT, old, this);
	}

	/**
	 * XP[̖ڐ̎ԁi_bjݒ肵܂B
	 * @param horizontalScaleWidth XP[̖ڐ̎ԁi_bj
	 */
	public void setHorizontalScaleWidth(long horizontalScaleWidth) {
		Object old = deepCopy();
		this.horizontalScaleWidth = horizontalScaleWidth;
		firePropertyChange(X_SCALE_CHANGE_EVENT, old, this);
	}

	/**
	 * R|[lg̗]̃CZbcԂ܂B
	 * @return R|[lg̗]̃CZbc
	 */
	public Insets getInsets() {
		return insets;
	}

	/**
	 * Otr[ȊO̗]̃CZbcԂ܂B
	 * @return R|[lg̗]̃CZbc
	 */
	public Insets getGraphiViewInsets() {
		return graphiViewInsets;
	}

	/**
	 * OtE} Color IuWFNg̔zԂ܂B
	 * @return OtE} Color IuWFNg̔z
	 */
	public Color[] getColors() {
		return colors;
	}

	/**
	 * ̃vpeBŐݒ肳ĂAO[ṽTCYԂ܂B
	 * @return O[ṽTCY
	 */
	public int getGroupSize() {
		return seriesPropertyList.size();
	}

	/**
	 * ݐݒ肳ĂO[vԂ܂B
	 * @return ݐݒ肳ĂO[v
	 */
	public int getGroup() {
		return group;
	}
	
	/**
	 * ݐݒ肳ĂO[vԂ܂B
	 * @return ݐݒ肳ĂO[v
	 */
	public String getGroupName() {
		return getGraphSeriesPropertyModel(getGroup()).getSeriesName();
	}

	/**
	 * IO[vݒ肵܂
	 * @param group O[v
	 */
	public void setGroup(int group) {
		if (group < 0 || group >= getGroupSize()) {
			throw new IllegalArgumentException("group : " + group);
		}
		logger.debug("group : " + group);
		Object old = deepCopy();
		this.group = group;
		firePropertyChange(GROUP_CHANGE_EVENT, old, this);
	}

	public void nextGroup() {
		if (group < (getGroupSize() - 1)) {
			Object old = deepCopy();
			group++;
			firePropertyChange(GROUP_CHANGE_EVENT, old, this);
		}
	}
	
	public void prevGroup() {
		if (0 < group) {
			Object old = deepCopy();
			group--;
			firePropertyChange(GROUP_CHANGE_EVENT, old, this);
		}
	}

	private GraphSeriesProperty getGraphSeriesPropertyModel(int group) {
		if (group < 0 || group >= getGroupSize()) {
			throw new IllegalArgumentException("group : " + group);
		}
		return (GraphSeriesProperty) seriesPropertyList.get(group);
	}

	/**
	 * ݒ肳ĂV[ỸTCYԂ܂B
	 * @return ݒ肳ĂV[ỸTCYiO[ṽV[Yj
	 */
	public int getSeriesSize() {
		return getGraphSeriesPropertyModel(group).getSeriesSize();
	}

	/**
	 * cXP[̍ŏlԂ܂B
	 * @param series V[Y
	 * @return cXP[̍ŏl
	 */
	public double getVerticalMinimum(int series) {
		return getGraphSeriesPropertyModel(group).getVerticalMinimum(series);
	}

	/**
	 * cXP[̍őlԂ܂B
	 * @param series V[Y
	 * @return cXP[̍ől
	 */
	public double getVerticalMaximum(int series) {
		return getGraphSeriesPropertyModel(group).getVerticalMaximum(series);
	}

	/**
	 * cXP[̍ŏlݒ肵܂B
	 * @param series V[Y
	 * @param verticalMinimum cXP[̍ŏl
	 */
	public void setVerticalMinimum(int series, double verticalMinimum) {
		Object old = deepCopy();
		getGraphSeriesPropertyModel(group).setVerticalMinimum(
			series,
			verticalMinimum);
		firePropertyChange(old, this);
	}

	/**
	 * cXP[̍őlݒ肵܂B
	 * @param series V[Y
	 * @param verticalMaximum cXP[̍ől
	 */
	public void setVerticalMaximum(int series, double verticalMaximum) {
		Object old = deepCopy();
		getGraphSeriesPropertyModel(group).setVerticalMaximum(
			series,
			verticalMaximum);
		firePropertyChange(old, this);
	}

	/**
	 * f[^voC_Ԃ܂B
	 * @param series V[Y
	 * @return f[^voC_
	 */
	public String getDataProviderName(int series) {
		return getGraphSeriesPropertyModel(group).getDataProviderName(series);
	}

	/**
	 * f[^z_Ԃ܂B
	 * @param series V[Y
	 * @return f[^z_
	 */
	public String getDataHolderName(int series) {
		return getGraphSeriesPropertyModel(group).getDataHolderName(series);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƒlԂ܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @return Qƒl
	 */
	public double getReferenceValue(int series, int fold) {
		return getGraphSeriesPropertyModel(group).getReferenceValue(series, fold);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƒlԂ܂B
	 * @param series V[Y
	 * @return Qƒl
	 */
	public double getReferenceValue(int series) {
		return getReferenceValue(series, 0);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƒlݒ肵܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @param referenceValue Qƒl
	 */
	public void setReferenceValue(int series, int fold, double referenceValue) {
		Object old = deepCopy();
		getGraphSeriesPropertyModel(group).setReferenceValue(
			series,
			fold,
			referenceValue);
		firePropertyChange(old, this);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƒlݒ肵܂B
	 * @param series V[Y
	 * @param referenceValue Qƒl
	 */
	public void setReferenceValue(int series, double referenceValue) {
		setReferenceValue(series, 0, referenceValue);
	}
	
	/**
	 * ݈ʒuÂĂO[v́AQƎݒ肵܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @param referenceTime QƎ
	 */
	public void setReferenceTime(int series, int fold, Timestamp referenceTime) {
		Object old = deepCopy();
		getGraphSeriesPropertyModel(group).setReferenceTime(
			series,
			fold,
			referenceTime);
		firePropertyChange(old, this);
	}
	
	/**
	 * ݈ʒuÂĂO[v́AQƎݒ肵܂B
	 * @param series V[Y
	 * @param referenceTime QƎ
	 */
	public void setReferenceTime(int series, Timestamp referenceTime) {
		setReferenceTime(series, 0, referenceTime);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƎԂ܂B
	 * @param series V[Y
	 * @param fold ܂Ԃʒu
	 * @return QƎ
	 */
	public Timestamp getReferenceTime(int series, int fold) {
		return getGraphSeriesPropertyModel(getGroup()).getReferenceTime(series, fold);
	}

	/**
	 * ݈ʒuÂĂO[v́AQƎԂ܂B
	 * @param series V[Y
	 * @return QƎ
	 */
	public Timestamp getReferenceTime(int series) {
		return getReferenceTime(series, 0);
	}

	/**
	 * ݈ʒuÂĂO[v́ACfbNXԂ܂B
	 * @return CfbNX̔z
	 */
	public int[] getGroupColumnIndex() {
		return new int[0];
	}

	/**
	 * V[YvpeB(O[v̐ݒ)ǉ܂B
	 * @param property V[YvpeB
	 */
	public void addSeriesProperty(GraphSeriesProperty property) {
		Object old = deepCopy();
		seriesPropertyList.add(property);
		firePropertyChange(old, this);
	}
	
	/**
	 * ݕ\Ănh[̃CfbNXݒ肵܂B
	 * @param name nh[
	 */
	public void setListHandlerIndex(int index) {
		if (index < 0 || index >= handlerName.length) {
			throw new IllegalArgumentException("index : " + index);
		}
		Object old = deepCopy();
		handlerIndex = index;
		firePropertyChange(X_SCALE_CHANGE_EVENT, old, this);
	}
	
	/**
	 * ݃CfbNXŎw肳Ănh[Ԃ܂B
	 * @return ݃CfbNXŎw肳Ănh[
	 */
	public String getListHandlerName() {
		return handlerName[handlerIndex];
	}
	
	/**
	 * ܂Ԃ񐔂Ԃ܂B
	 * @return ܂Ԃ
	 */
	public int getFoldCount() {
		return foldCount;
	}

	/**
	 * ݈ʒuÂĂO[v́A|CĝԂ܂B
	 * @param series V[Y
	 * @return ݈ʒuÂĂO[v́ACfbNXԂ܂B
	 */
	public String getPointName(int series) {
		return getGraphSeriesPropertyModel(getGroup()).getPointName(series);
	}


	/**
	 * ݈ʒuÂĂO[v́APʋLԂ܂B
	 * @param series V[Y
	 * @return ݈ʒuÂĂO[v́APʋLԂ܂B
	 */
	public String getPointMark(int series) {
		return getGraphSeriesPropertyModel(getGroup()).getPointMark(series);
	}

	/**
	 * ݈ʒuÂĂO[v́Aݒl\V{Ԃ܂B
	 * @param series V[Y
	 * @return ݈ʒuÂĂO[v́Aݒl\V{Ԃ܂B
	 */
	public ExplanatoryNotesText getSymbol(int series) {
		return getGraphSeriesPropertyModel(getGroup()).getSymbol(series);
	}
	
	/**
	 * ݃NbNĂQƓԂ܂
	 * @return ݃NbNĂQƓԂ܂
	 */
	public Timestamp getReferenceTime() {
		return referenceTime;
	}
	
	/**
	 * ݃NbNĂQƓݒ肵܂
	 * @param time ݃NbNĂQƓݒ肵܂
	 */
	public void setReferenceTime(Timestamp time) {
		Timestamp old = null;
		if (referenceTime != null) {
			old = (Timestamp) referenceTime.clone();
		}
		referenceTime = time;
		firePropertyChange(old, time);
	}

	/**
	 * \Ot̉sNZԂ܂B
	 * @return \Ot̉sNZԂ܂B
	 */
	public int getHorizontalPixcelWidth() {
		return horizontalPixcelWidth;
	}
	
	/**
	 * XXP[̖ڐ蕝Ԃ܂B
	 * @return XXP[̖ڐ蕝Ԃ܂B
	 */
	public int getScaleOneHeightPixel() {
		return scaleOneHeightPixel;
	}

	/**
	 * Qƕ\̕FԂ܂
	 * @return Qƕ\̕FԂ܂
	 */
	public Color getExplanatoryColor() {
		return explanatoryColor;
	}

	/**
	 * Qƕ\̃tHgԂ܂
	 * @return Qƕ\̃tHgԂ܂
	 */
	public Font getExplanatoryFont() {
		return explanatoryFont;
	}

	
    public Collection getGroupNames() {
        ArrayList groupNames = new ArrayList(seriesPropertyList.size());
        int index = 0;
        for (Iterator i = seriesPropertyList.iterator(); i.hasNext(); index++) {
            GraphSeriesProperty gp = (GraphSeriesProperty) i.next();
            groupNames.add(String.format("%03d : %s", index, gp.getSeriesName()));
        }
        return groupNames;
    }

    public String getFirstFormat() {
        return firstFormat;
    }
    public String getSecondFormat() {
        return secondFormat;
    }
    public void setFirstFormat(String format) {
        if (format == null) {
            format = "MM/dd";
        }
		Object old = deepCopy();
        firstFormat = format;
		firePropertyChange(X_SCALE_CHANGE_EVENT, old, this);
    }
    public void setSecondFormat(String format) {
        if (format == null) {
            format = "HH:mm";
        }
		Object old = deepCopy();
        secondFormat = format;
		firePropertyChange(X_SCALE_CHANGE_EVENT, old, this);
    }

	public VerticallyScaleProperty getVerticallyScaleProperty() {
		return verticallyScaleProperty;
	}

    /**
	 * ̃IuWFNg̕\Ԃ܂B
	 * vpeB𕶎\ĕԂ܂BÃ\bh͊JiKŎgpׂłA
	 * eXgړIȊOŎgpȂłBAԂeύX邱Ƃ܂B
	 * @return IuWFNg̕\
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("verticalScaleCount:" + verticalScaleCount);
		buffer.append(",verticalScaleHeight:" + verticalScaleHeight);
		buffer.append(",horizontalScaleCount:" + horizontalScaleCount);
		buffer.append(",horizontalScaleWidth:" + horizontalScaleWidth);
		buffer.append(",insets:" + insets);
		for (int i = 0; i < colors.length; i++) {
			buffer.append(",colors:" + colors[i]);
		}
		List handler = Arrays.asList(handlerName);
		buffer.append("handlerName:" + handler);
		buffer.append(",group:" + group);
		buffer.append("seriesPropertyList:" + seriesPropertyList);
		buffer.append(",foldCount:" + foldCount);
		buffer.append(",referenceTime:").append(referenceTime)
		.append(",horizontalPixcelWidth:").append(horizontalPixcelWidth)
		.append(",scaleOneHeightPixel:").append(scaleOneHeightPixel)
		.append(",firstFormat:").append(firstFormat)
		.append(",secondFormat:").append(secondFormat)
		.append("verticalScaleCount:").append(verticallyScaleProperty);
		return buffer.toString();
	}

	/**
	 * ʂ̃IuWFNgÃIuWFNgƓׂ܂B
	 * ʂ͈ null łȂÃIuWFNgƓevpeB[itB[hj̒l
	 * IuWFNgłꍇ true Ԃ܂B
	 * @param obj  DefaultGraphPropertyModel Ɠǂ肳IuWFNg
	 * @return IuWFNgłꍇ trueAłȂꍇ false
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof DefaultGraphPropertyModel)) {
			return false;
		}
		DefaultGraphPropertyModel pm = (DefaultGraphPropertyModel) obj;
		return pm.group == this.group
			&& pm.handlerIndex == this.handlerIndex
			&& pm.verticalScaleCount == this.verticalScaleCount
			&& pm.verticalScaleHeight == this.verticalScaleHeight
			&& pm.horizontalScaleCount == this.horizontalScaleCount
			&& pm.horizontalScaleWidth == this.horizontalScaleWidth
			&& pm.insets.equals(this.insets)
			&& pm.graphiViewInsets.equals(this.graphiViewInsets)
			&& Arrays.equals(pm.colors, this.colors)
			&& Arrays.equals(pm.handlerName, this.handlerName)
			&& pm.seriesPropertyList.equals(this.seriesPropertyList)
			&& pm.foldCount == this.foldCount
			&& ((pm.referenceTime == null && this.referenceTime == null) || pm.referenceTime.equals(this.referenceTime))
			&& pm.horizontalPixcelWidth == this.horizontalPixcelWidth
			&& pm.scaleOneHeightPixel == this.scaleOneHeightPixel
			&& ((pm.explanatoryColor == null && this.explanatoryColor == null) || pm.explanatoryColor.equals(this.explanatoryColor))
			&& ((pm.explanatoryFont == null && this.explanatoryFont == null) || pm.explanatoryFont.equals(this.explanatoryFont))
			&& pm.firstFormat.equals(this.firstFormat)
			&& pm.secondFormat.equals(this.secondFormat)
			&& pm.verticallyScaleProperty.equals(verticallyScaleProperty);
	}

	/**
	 *  DefaultGraphPropertyModel ̃nbVR[hvZ܂B
	 * @return  DefaultGraphPropertyModel ̃nbVR[hl
	 */
	public int hashCode() {
		int result = 17;
		result = 37 * result + group;
		result = 37 * result + handlerIndex;
		result = 37 * result + verticalScaleCount;
		result = 37 * result + verticalScaleHeight;
		result = 37 * result + horizontalScaleCount;
		result =
			37 * result
				+ (int) (horizontalScaleWidth ^ (horizontalScaleWidth >>> 32));
		result = 37 * result + insets.hashCode();
		result = 37 * result + graphiViewInsets.hashCode();
		for (int i = 0; i < colors.length; i++) {
			result = 37 * result + colors[i].hashCode();
		}
		for (int i = 0; i < handlerName.length; i++) {
			result = 37 * result + handlerName[i].hashCode();
		}
		result = 37 * result + seriesPropertyList.hashCode();
		result = 37 * result + foldCount;
		if (referenceTime != null) {
			result = 37 * result + referenceTime.hashCode();
		}
		result = 37 * result + horizontalPixcelWidth;
		result = 37 * result + scaleOneHeightPixel;
		if (explanatoryColor != null)
		    result = 37 * result + explanatoryColor.hashCode();
		if (explanatoryFont != null)
		    result = 37 * result + explanatoryFont.hashCode();
		result = 37 * result + firstFormat.hashCode();
		result = 37 * result + secondFormat.hashCode();
		result = 37 * result + verticallyScaleProperty.hashCode();
		return result;
	}
}
