package org.F11.scada.applet.schedule;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import javax.swing.JComponent;

import org.F11.scada.xwife.applet.PageChanger;
import org.apache.log4j.Logger;

/**
 * XPW[NX𐶐钊ۃNXłB XPW[r[̃oG[V́ÃNXpt@NgNX쐬ĂB
 * AbstractFactory Pattern gpĂ܂B
 * 
 * @todo XPW[̃O[vƁA@ʃXPW[̑ΉB
 */
public abstract class ScheduleFactory {
	/** XPW[f̎QƂł */
	protected ScheduleModel scheduleModel;

	private static Logger logger = Logger.getLogger(ScheduleFactory.class);

	/**
	 * RXgN^
	 * 
	 * @see getFactory
	 * @param alarmRef [gf[^IuWFNg
	 */
	public ScheduleFactory(ScheduleModel scheduleModel) {
		this.scheduleModel = scheduleModel;
	}

	/**
	 * X^eBbNEt@Ng\bhłB ̃\bhgpāAXPW[IuWFNg̃CX^X𐶐܂B
	 * 
	 * @param alarmRef [gf[^IuWFNg
	 * @param viewClass gpr[NX
	 * @param isSort ԃ\[g̗L
	 * @param isNonTandT Er[̗L
	 * 
	 */
	public static ScheduleFactory getFactory(
			ScheduleModel scheduleModel,
			String viewClass,
			boolean isSort,
			boolean isNonTandT,
			String pageId,
			boolean isLenient,
			PageChanger changer) {
		ScheduleFactory factory = null;
		String realClassName = "org.F11.scada.applet.schedule." + viewClass;
		logger.debug("Class Name : " + realClassName);

		try {
			Class factoryClass = Class.forName(realClassName);
			Class[] param =
				{
					ScheduleModel.class,
					Boolean.TYPE,
					Boolean.TYPE,
					String.class,
					Boolean.TYPE,
					PageChanger.class };
			Constructor constructor = factoryClass.getConstructor(param);
			factory =
				(ScheduleFactory) constructor.newInstance(new Object[] {
					scheduleModel,
					Boolean.valueOf(isSort),
					Boolean.valueOf(isNonTandT),
					pageId,
					Boolean.valueOf(isLenient),
					changer });
		} catch (ClassNotFoundException ex) {
			logger.warn("class not found = " + viewClass);
		} catch (InvocationTargetException ex2) {
			ex2.getTargetException().printStackTrace();
			// ex2.printStackTrace();
		} catch (Exception exp) {
			exp.printStackTrace();
		}
		return factory;
	}

	/**
	 * r[܂񂾃R|[lgԂۃ\bhłB TuNXŎ܂B
	 * 
	 * @return r[܂񂾃R|[lg(ʏ̓XN[yCԂ܂)
	 */
	public abstract JComponent createView();

	/**
	 * c[o[܂񂾃R|[lgԂۃ\bhłB TuNXŎ܂B
	 * 
	 * @return c[o[܂񂾃R|[lg
	 */
	public abstract JComponent createToolBar();
}
