/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/data/WifeQualityFlag.java,v 1.3.6.1 2004/11/29 07:12:47 frdm Exp $
 * $Revision: 1.3.6.1 $
 * $Date: 2004/11/29 07:12:47 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.data;

import java.io.ObjectStreamException;
import java.io.Serializable;

import jp.gr.javacons.jim.QualityFlag;

/**
 * WifeData  QualityFlag NXłB
 * ^CvZ[t enum NXEp^[gpāAQualityFlagC^[tFCX
 * bvĂ܂B
 * ̃NX͕sσNXłB
 */
public final class WifeQualityFlag implements QualityFlag, Serializable {
	/** VAo[WUIDłB */
	private static final long serialVersionUID = 7268587145123423407L;
	/** NHeBɊւgbvx̏ƂāCُlł邱Ƃ\B */
	public static final WifeQualityFlag BAD = new WifeQualityFlag(QualityFlag.BAD);
	/** NHeBɊւgbvx̏ƂāC킩ُ킩𔻒łȂƂ\B */
	public static final WifeQualityFlag UNCERTAIN = new WifeQualityFlag(QualityFlag.UNCERTAIN);
	/** NHeBɊւgbvx̏ƂāClł邱Ƃ\B */
	public static final WifeQualityFlag GOOD = new WifeQualityFlag(QualityFlag.GOOD);
	/** NHeBɊւgbvx̏ƂāCf[^IuWFNglɏlݒ肳Ă邱Ƃ\B */
	public static final WifeQualityFlag INITIAL = new WifeQualityFlag(2);
	//VACŶ߂ɕKvȏ
	private static int nextOrdinal = 0;
	private final int ordinal = nextOrdinal++;
	private static final WifeQualityFlag[] VALUES = {
		BAD, UNCERTAIN, GOOD, INITIAL,
	};

	/** NHeB\lłB */
	private final transient int quality;

	/** NHeB̕\ */
	private static final String[] qualityString = {
	        "BAD", "UNCERTAIN", "INITIAL", "GOOD",
	};

	/**
	 * RXgN^łB
	 * NHeB\萔AɎ܂Bprivate RXgN^Ȃ̂ŁA
	 * pA new ZqŃCX^X𐶐邱Ƃł܂B
	 * @param quality NHeB\萔
	 */
	private WifeQualityFlag(int quality) {
		this.quality = quality;
	}

	/**
	 * QualityFlag C^[tFCX̎łB
	 * @return NHeB\萔
	 */
	public int getQuality() {
		return quality;
	}

	/**
	 * fVACYɂCX^X̐h܂B
	 */
	private Object readResolve() throws ObjectStreamException {
		return VALUES[ordinal];
	}

	/**
	 * QualityFlag C^[tFCX̎łB~bg͎Ă܂B
	 */
	public int getLimit() {
		return QualityFlag.LIMIT_NOT_LIMITED;
	}

	/**
	 * QualityFlag C^[tFCX̎łBXe[^X͎Ă܂B
	 */
	public int getSubStatus() {
		return QualityFlag.SUBSTATUS_NON_SPECIFIC;
	}
	
	/* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return qualityString[quality];
    }
}
