/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/parser/alarm/FontConfig.java,v 1.1 2003/10/23 09:58:34 frdm Exp $
 * $Revision: 1.1 $
 * $Date: 2003/10/23 09:58:34 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.parser.alarm;

import java.awt.Font;
import java.util.HashMap;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * tHgێݒJavaBeanNXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public final class FontConfig {
	/** tHgX^C̕ƒ萔̃}bvł */
	private static HashMap styleMap = new HashMap();
	/** tHg */
	private String type;
	/** tHg|Cg */
	private int point;
	/** tHgX^C */
	private String style;
	
	static {
		styleMap.put("PLAIN", new Integer(Font.PLAIN));
		styleMap.put("BOLD", new Integer(Font.BOLD));
		styleMap.put("ITALIC", new Integer(Font.ITALIC));
		styleMap.put("BOLD+ITALIC", new Integer(Font.BOLD + Font.ITALIC));
	};

	/**
	 * tHg|CgԂ܂
	 * @return tHg|Cg
	 */
	public int getPoint() {
		return point;
	}

	/**
	 * tHgX^CԂ܂
	 * @return tHgX^C
	 */
	public String getStyle() {
		return style;
	}

	/**
	 * tHg^CvԂ܂
	 * @return tHg^Cv
	 */
	public String getType() {
		return type;
	}

	/**
	 * tHg|Cgݒ肵܂
	 * @param i tHg|Cg
	 */
	public void setPoint(int i) {
		point = i;
	}

	/**
	 * tHgX^Cݒ肵܂
	 * @param i tHgX^C
	 */
	public void setStyle(String string) {
		style = string;
	}

	/**
	 * tHg^Cvݒ肵܂
	 * @param string tHg^Cv
	 */
	public void setType(String string) {
		type = string;
	}

	/**
	 * ̃IuWFNg̕Ԃ܂B
	 * jakarta commons Lang, ToStringBuilder̎ɈˑĂ܂B
	 */
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	/**
	 * tHgX^CFontŒ`Ă萔ŕԂ܂B
	 * `ĂȂ񂪎w肳ꂽꍇ́AFont.PLAINԂ܂B
	 * @return FontŒ`Ă萔
	 */
	private int getFontStyle() {
		String key = style.toUpperCase();
		return styleMap.containsKey(key)
			? ((Integer) styleMap.get(key)).intValue()
			: Font.PLAIN;
	}
	
	/**
	 * vpeB萶tHgԂ܂B
	 * @return vpeB萶tHgԂ܂B
	 */
	public Font getFont() {
		return new Font(type, getFontStyle(), point);
	}
}
