/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.parser.client;

import junit.framework.TestCase;

/**
 * ClientsDefine ̃eXgP[XłB
 */
public class ClientsDefineTest extends TestCase {

	public ClientsDefineTest(String arg0) {
		super(arg0);
	}

	public void test001() throws Exception {
		ClientsDefine cd = new ClientsDefine("ClientsDefineTest.xml");

		assertEquals("192.168.0.101", cd.getClientConfig("192.168.0.101")
				.getIpaddress());
		assertEquals("user101", cd.getClientConfig("192.168.0.101").getName());

		assertEquals("192.168.0.102", cd.getClientConfig("192.168.0.102")
				.getIpaddress());
		assertEquals("user102", cd.getClientConfig("192.168.0.102").getName());

		assertEquals("", cd.getClientConfig("192.168.0.103").getIpaddress());
		assertEquals("", cd.getClientConfig("192.168.0.103").getName());

		assertEquals("", cd.getClientConfig("127.0.0.1").getIpaddress());
		assertEquals("", cd.getClientConfig("127.0.0.1").getName());
	}
}
