package org.F11.scada.scheduling;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;



/**
 * Cӂ̊ԊuŃ^XNsXPW[[NXłB
 * ̃NX̓XbhZ[tłF邱ƖɁA Schedule IuWFNgL邱Ƃ\łB
 * 
 * ̃NX java.util.Timer NXgpĂ܂
 */
public class Scheduler {

	/**
	 * ^XNsCi[NXłB
	 * w肳ꂽɂȂƁA^XN run \bhs ScheduleIterator ɂčăXPW[s܂B
	 */
    class SchedulerTimerTask extends TimerTask {
    	/** s^XN */
        private SchedulerTask schedulerTask;
        /** ̓Ԃ ScheduleIterator */
        private ScheduleIterator iterator;

        /**
         * s^XN ScheduleIterator ŃIuWFNg܂
         * @param schedulerTask s^XN
         * @param iterator ScheduleIterator IuWFNg
         */
        public SchedulerTimerTask(SchedulerTask schedulerTask,
                ScheduleIterator iterator) {
            this.schedulerTask = schedulerTask;
            this.iterator = iterator;
        }

		/**
		 * seAăXPW[܂
		 */
        public void run() {
            schedulerTask.run();
            reschedule(schedulerTask, iterator);
        }
    }

	/** XPW[Ɏgp Timer IuWFNg */
    private final Timer timer = new Timer();

	/**
	 * RXgN^
	 */
    public Scheduler() {}

	/**
	 * o^ꂽ^XNÃXPW[[𒆎~܂B
	 * s̃^XNꍇ́AI܂ő҂Ă~܂B
	 * ̃\bh2ȏĂяoꂽ͉N܂B
	 */
    public void cancel() {
        timer.cancel();
    }

	/**
	 * s^XNCe[^[Œ`ꂽԊuŎs܂B
	 * @param schedulerTask sXPW[
	 * @param iterator sԊu`Ce[^[
	 * @throws IllegalStateException ɑ݂̂XPW[悤ƂA͒~ꂽXPW[o^悤Ƃ
	 */
    private void schedule(SchedulerTask schedulerTask,
            ScheduleIterator iterator) {

        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            synchronized(schedulerTask.lock) {
                if (schedulerTask.state != SchedulerTask.VIRGIN) {
                    throw new IllegalStateException("Task already scheduled " +
                        "or cancelled");
                }
                schedulerTask.state = SchedulerTask.SCHEDULED;
                schedulerTask.timerTask =
                    new SchedulerTimerTask(schedulerTask, iterator);
                timer.schedule(schedulerTask.timerTask, time);
            }
        }
    }

	/**
	 * s^XNCe[^[Œ`ꂽԊuŎs܂B
	 * @param schedulerTask sXPW[
	 * @throws IllegalStateException ɑ݂̂XPW[悤ƂA͒~ꂽXPW[o^悤Ƃ
	 */
	public void schedule(Schedule schedule) {
		schedule(schedule.getTask(), schedule.getScheduleIterator());
	}

	/**
	 * ăXPW[
	 * @param schedulerTask s^XN
	 * @param iterator Ce[^[
	 */
    private void reschedule(SchedulerTask schedulerTask,
            ScheduleIterator iterator) {

        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            synchronized(schedulerTask.lock) {
                if (schedulerTask.state != SchedulerTask.CANCELLED) {
                    schedulerTask.timerTask =
                        new SchedulerTimerTask(schedulerTask, iterator);
                    timer.schedule(schedulerTask.timerTask, time);
                }
            }
        }
    }

}
