/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/server/alarm/AlarmTableJournal.java,v 1.3 2003/02/21 05:08:55 frdm Exp $
 * $Revision: 1.3 $
 * $Date: 2003/02/21 05:08:55 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.server.alarm;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;

/**
 * NCAgET[o[Ԃ̌xEԃe[ufXVɎgpsf[^NXłB
 * ̃NX͕sσNXłBNX̋@\ꍇɁAgł͂ȂϏfgpĉB
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public final class AlarmTableJournal implements Serializable {
	private static final long serialVersionUID = -5727184066915388566L;
	/** ǉsf[^\܂B */
	public static final int INSERT_OPERATION = 1;
	/** 폜sf[^\܂B */
	public static final int REMOVE_OPERATION = 2;
	/** XVsf[^\܂B */
	public static final int MODIFY_OPERATION = 0;

	private final DataValueChangeEventKey key;
	private final int operationType;
	private final Object[] data;

	/**
	 * sf[^𐶐܂B̃IuWFNg͌xꗗ̃e[ufANCAgET[o[Ԃœ邽߂Ɏgp܂B
	 * @param key s̃L[IuWFNg
	 * @param data e[uf̍s
	 * @param rowType s
	 */	
	private AlarmTableJournal(DataValueChangeEventKey key, Object[] data, int rowType) {
		this.key = key;
		this.data = new Object[data.length];
		System.arraycopy(data, 0, this.data, 0, data.length);
		this.operationType = rowType;
	}

	/**
	 * ǉsf[^𐶐܂B
	 * @param key s̃L[IuWFNg
	 * @param data e[uf̍s
	 * @return ǉsf[^
	 */
	public static AlarmTableJournal createRowDataAddOpe(
			DataValueChangeEventKey key,
			Object[] data) {
		checkArgument(key, data);
		return new AlarmTableJournal(key, data, INSERT_OPERATION);
	}
	
	/**
	 * 폜sf[^𐶐܂B
	 * @param key s̃L[IuWFNg
	 * @param data e[uf̍s
	 * @return 폜sf[^
	 */
	public static AlarmTableJournal createRowDataRemoveOpe(
			DataValueChangeEventKey key,
			Object[] data) {
		checkArgument(key, data);
		return new AlarmTableJournal(key, data, REMOVE_OPERATION);
	}

	/**
	 * XVsf[^𐶐܂B
	 * @param key s̃L[IuWFNg
	 * @param data e[uf̍s
	 * @return XVsf[^
	 */
	public static AlarmTableJournal createRowDataModifyOpe(
			DataValueChangeEventKey key,
			Object[] data) {
		checkArgument(key, data);
		return new AlarmTableJournal(key, data, MODIFY_OPERATION);
	}
	
	private static void checkArgument(DataValueChangeEventKey key, Object[] data) {
		if (key == null) {
			throw new IllegalArgumentException("key is null.");
		}
		if (data == null) {
			throw new IllegalArgumentException("data is null.");
		}
	}

	/**
	 * e[ufɎgpsf[^Ԃ܂B
	 * @return e[ufɎgpsf[^
	 */
	public Object[] getData() {
		Object[] rd = new Object[data.length];
		System.arraycopy(data, 0, rd, 0, data.length);
		return rd;
	}

	/**
	 * sf[^̑@Ԃ܂B߂l͈ȉ̒萔ŕԂ܂B
	 * <UL>
	 * <LI>ADD_OPERATION ǉsf[^
	 * <LI>REMOVE_OPERATION 폜sf[^
	 * <LI>MODIFY_OPERATION XVsf[^
	 * </UL>
	 * @return sf[^̑@ADD_OPERATION, REMOVE_OPERATION, MODIFY_OPERATION̂ꂩ
	 * 萔ŕԂ܂B
	 */
	public int getOperationType() {
		return operationType;
	}

	/**
	 * sf[^̃^CX^vԂ܂B
	 * @return sf[^̃^CX^v
	 */	
	public Timestamp getTimestamp() {
		return key.getTimeStamp();
	}

	/**
	 * sf[^̃^CX^vݒ肵 AlarmTableJournal IuWFNgԂ܂B
	 * @param t ݒ肷^CX^v
	 * @return AlarmTableJournal IuWFNg
	 */	
	public AlarmTableJournal setTimestamp(Timestamp t) {
		if (t == null) {
			throw new IllegalArgumentException("Set Time is null.");
		}
		
		return new AlarmTableJournal(key.setTimeStamp(t), data, operationType);
	}
	
	/**
	 * sf[^̃|CgԂ܂B
	 * @return sf[^̃|Cg
	 */
	public int getPoint() {
		return key.getPoint();
	}
	
	/**
	 * sf[^̃f[^voC_Ԃ܂B
	 * @return sf[^̃f[^voC_
	 */
	public String getProvider() {
		return key.getProvider();
	}
	
	/**
	 * sf[^̃f[^z_Ԃ܂B
	 * @return sf[^̃f[^z_
	 */
	public String getHolder() {
		return key.getHolder();
	}
	
	/*
	 * ̃IuWFNg̃^CX^vÃ^CX^v傫 true łȂ false Ԃ܂B
	 * @param t ^CX^v
	 * @return ̃IuWFNg̃^CX^vÃ^CX^v傫 true łȂ false Ԃ܂B
	public boolean isSendData(Timestamp t) {
		Timestamp ts = key.getTimeStamp();
		return (ts.compareTo(t) > 0) ? true : false;
	}
	 */

	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 * @return ̃IuWFNg̕\
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(key.toString());
		buffer.append(",operationType=" + operationType);
		buffer.append(",data=" + Arrays.asList(data).toString());
		return buffer.toString();
	}
	
	/**
	 * ̃IuWFNg̒lׁAȂ true Ԃ܂B
	 * @param obj rΏۂ̃IuWFNg
	 * @return ̃IuWFNg̒lׁAȂ true Ԃ܂B
	 */
	public boolean equals(Object obj) {
		if (obj == this) {	
			return true;
		}
		
		if (!(obj instanceof AlarmTableJournal)) {
			return false;
		}
		
		AlarmTableJournal aj = (AlarmTableJournal) obj;
		return key.equals(aj.key)
				&& operationType == aj.operationType
				&& Arrays.equals(data, aj.data);
	}

	/**
	 * ̃IuWFNg̃nbVԂ܂
	 * @return ̃IuWFNg̃nbV
	 */
	public int hashCode() {
		int result = 17;
		result = 37 * result + key.hashCode();
		result = 37 * result + operationType;
		for (int i = 0; i < data.length; i++) {
			if (data[i] != null) {
				result = 37 * result + data[i].hashCode();
			}
		}
		return result;
	}

	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new AlarmTableJournal(key, data, operationType);
	}
}
