/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/server/io/ValueListHandlerElement.java,v 1.3 2003/10/15 08:36:51 frdm Exp $
 * $Revision: 1.3 $
 * $Date: 2003/10/15 08:36:51 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.server.io;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

import org.F11.scada.server.event.LoggingDataListener;
import org.F11.scada.server.register.HolderString;

/**
 * MOf[^̃nhGg̃C^[tFCXłB
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public interface ValueListHandlerElement extends LoggingDataListener {
	/**
	 * R[hIuWFNgԂ܂B
	 * @return R[hIuWFNg
	 */
	public Object next();

	/**
	 * ̃R[hIuWFNg݂鎞́Atrue Ԃ܂B
	 * @return ̃R[hIuWFNg݂鎞́Atrue łȂꍇ false Ԃ܂B
	 */
	public boolean hasNext();

	/**
	 * ŏ̃^CX^vԂ܂B
	 */
	public Object firstKey();

	/**
	 * Ō̃^CX^vԂ܂B
	 */
	public Object lastKey();

	/**
	 * ^CX^v key ȑÕR[hA|C^ʒuÂ܂B
	 * ̃\bhňʒuÂꂽ|C^́A key ȑÕR[hP܂݂܂B
	 * AAkey 擪R[hȑÕR[hꍇ́A擪R[hɂȂ܂B
	 * @param key 郌R[h̃^CX^v
	 */
	public void findRecord(Timestamp key);
	
	/**
	 * keyŎw肳ꂽȍ~̃MOf[^MapCX^XŕԂ܂B
	 * @param key XV
	 */
	public Map getUpdateLoggingData(Timestamp key);
	
	/**
	 * ێĂf[^XVꂽɒʒmǉ܂B
	 * @param listener
	 */
	public void addLoggingDataListener(LoggingDataListener listener);
	
	/**
	 * ʒm폜܂B
	 * @param listener
	 */
	public void removeLoggingDataListener(LoggingDataListener listener);

	/**
	 * pf[^SortedMapԂ܂B
	 * @return pf[^SortedMapԂ܂B
	 */
	public SortedMap getInitialData();
	
	/**
	 * ̃^XNz_Ԃ܂B
	 * 
	 * @return ̃^XNz_Ԃ܂B
	 */
	List<HolderString> getHolders();
}
