/*
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.io.nio.dbms;

/**
 * eDBMSpSQL`C^[tFCXłB
 * @author maekawa
 */
public interface Dbms {
	/**
	 * MOe[uSQLԂ܂
	 * @param tableName e[u
	 * @return e[uSQLԂ܂
	 */
	String getCreateSql(String tableName);
	/**
	 * MOe[u폜SQLԂ܂
	 * @param tableName e[u
	 * @return e[u폜SQLԂ܂
	 */
	String getDropSql(String tableName);
	/**
	 * MOe[uSQLԂ܂
	 * @param tableName e[u
	 * @return MOe[uSQLԂ܂
	 */
	String[] getCreateIndexSql(String tableName);
	/**
	 * R[h}SQLԂ܂
	 * @param tableName e[u
	 * @return R[h}SQLԂ܂
	 */
	String getInsertSql(String tableName);
	/**
	 * rW擾SQLԂ܂B
	 * @param tableName e[u
	 * @return rW擾SQLԂ܂B
	 */
	String getRevisionSql(String tableName);
	/**
	 * őftHgŃR[hSQLԂ܂
	 * @param tableName e[u
	 * @return őftHgŃR[hSQLԂ܂
	 */
	String getSelectSql(String tableName);
	/**
	 * w茏ŃR[hSQLԂ܂
	 * @param tableName e[u
	 * @param limit ő僌R[h
	 * @return w茏ŃR[hSQLԂ܂
	 */
	String getSelectHolderIdSql(String tableName, int limit);
	/**
	 * ŃR[hSQLԂ܂
	 * @param tableName e[u
	 * @return ŃR[hSQLԂ܂
	 */
	String getSelectTimeSql(String tableName);

	/**
	 * ŌÃR[hSQLԂ܂
	 * @param tableName e[u
	 * @return ŌÃR[hSQLԂ܂
	 */
	String getSelectFirstSql(String tableName);

	/**
	 * ŐVR[hSQLԂ܂
	 * @param tableName e[u
	 * @return ŐVR[hSQLԂ܂
	 */
	String getSelectLastSql(String tableName);

	/**
	 * ȏVR[h𒊏oSQLԂ܂
	 * @param tableName e[u
	 * @param limit R[h
	 * @return ȏVR[h𒊏oSQLԂ܂
	 */
	String getSelectAfterSql(String tableName, int limit);

	/**
	 * ÂR[h𒊏oSQLԂ܂
	 * @param tableName e[u
	 * @param limit R[h
	 * @return ÂR[h𒊏oSQLԂ܂
	 */
	String getSelectBeforeSql(String tableName, int limit);

	/**
	 * t̊Ԃ𒊏oSQLԂ܂
	 * @param tableName e[u
	 * @return t̊Ԃ𒊏oSQLԂ܂
	 */
	String getSelectBetweenTimeSql(String tableName);
}
