/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.co.frdm.Vamp.Util;
import jp.co.frdm.Vamp.emulator.AbstractPlc;
import jp.co.frdm.Vamp.emulator.PlcMemory;
import jp.co.frdm.Vamp.emulator.converter.MC3E;

public class MELSEC_Q
extends AbstractPlc {
    private int fileRegisterSize;
    private Map memoryMap;
    private Map memKindMap;
    private MC3E converter;

    public void setPlcParam(StringTokenizer st) {
        this.converter = new MC3E(Integer.parseInt(st.nextToken("\t")), Integer.parseInt(st.nextToken("\t")));
        this.fileRegisterSize = Integer.parseInt(st.nextToken("\t"));
        if (1018 < this.fileRegisterSize) {
            this.fileRegisterSize = 1018;
        }
        this.memoryMap = new HashMap();
        this.memoryMap.put("X(Bit)", new PlcMemory.PlcBitMemory(8192));
        this.memoryMap.put("Y(Bit)", new PlcMemory.PlcBitMemory(8192));
        this.memoryMap.put("M(Bit)", new PlcMemory.PlcBitMemory(8192));
        this.memoryMap.put("L(Bit)", new PlcMemory.PlcBitMemory(8192));
        this.memoryMap.put("B(Bit)", new PlcMemory.PlcBitMemory(8192));
        this.memoryMap.put("SM(Bit)", new PlcMemory.PlcBitMemory(2048));
        this.memoryMap.put("D", new PlcMemory.PlcWordMemory(12288));
        this.memoryMap.put("W", new PlcMemory.PlcWordMemory(8192));
        this.memoryMap.put("R", new PlcMemory.PlcWordMemory(this.fileRegisterSize * 1024));
        this.memoryMap.put("SD", new PlcMemory.PlcWordMemory(2048));
        this.memKindMap = new HashMap();
        this.memKindMap.put(new Integer(156), this.memoryMap.get("X(Bit)"));
        this.memKindMap.put(new Integer(157), this.memoryMap.get("Y(Bit)"));
        this.memKindMap.put(new Integer(144), this.memoryMap.get("M(Bit)"));
        this.memKindMap.put(new Integer(146), this.memoryMap.get("L(Bit)"));
        this.memKindMap.put(new Integer(160), this.memoryMap.get("B(Bit)"));
        this.memKindMap.put(new Integer(145), this.memoryMap.get("SM(Bit)"));
        this.memKindMap.put(new Integer(168), this.memoryMap.get("D"));
        this.memKindMap.put(new Integer(180), this.memoryMap.get("W"));
        this.memKindMap.put(new Integer(176), this.memoryMap.get("R"));
        this.memKindMap.put(new Integer(175), this.memoryMap.get("R"));
        this.memKindMap.put(new Integer(169), this.memoryMap.get("SD"));
    }

    public String getPlcParam() {
        return this.getName() + "\t" + String.valueOf(this.getPortNo()) + "\tMELSEC_Q\t" + this.converter.getParam() + "\t" + String.valueOf(this.fileRegisterSize);
    }

    public String getPlcInfo() {
        return "MELSEC_Q " + this.converter.getInfo() + " R " + String.valueOf(this.fileRegisterSize);
    }

    public List getPlcMemNames() {
        ArrayList list = new ArrayList(this.memoryMap.keySet());
        Collections.sort(list);
        return list;
    }

    public void writePlcMem(String memName, int addr, byte[] data) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            mem.setData(addr, data);
        }
    }

    public byte[] readPlcMem(String memName, int addr, int wordLen) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            return mem.getData(addr, wordLen);
        }
        return null;
    }

    public int getPlcMemMax(String memName) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            return mem.getAddressMax();
        }
        return 0;
    }

    public byte[] recvPerformed(byte[] recvData) {
        if (!this.getStat()) {
            return null;
        }
        if (!this.converter.checkCommand(recvData)) {
            return null;
        }
        this.incCount();
        if (this.converter.getSubCommandCode() == 0) {
            switch (this.converter.getCommandCode()) {
                case 1025: {
                    return this.commandRead();
                }
                case 5121: {
                    return this.commandWrite();
                }
            }
        }
        return this.converter.createErrorResponse(80);
    }

    private byte[] commandRead() {
        int addr = this.converter.getDeviceAdder();
        int wlen = this.converter.getDeviceLength();
        PlcMemory mem = (PlcMemory)this.memKindMap.get(new Integer(this.converter.getDeviceCode()));
        if (mem != null) {
            byte[] data = mem.getData(addr, wlen);
            if (data != null) {
                return this.converter.createResponse(data);
            }
            return this.converter.createErrorResponse(2);
        }
        return this.converter.createErrorResponse(86);
    }

    private byte[] commandWrite() {
        int addr = this.converter.getDeviceAdder();
        PlcMemory mem = (PlcMemory)this.memKindMap.get(new Integer(this.converter.getDeviceCode()));
        if (mem != null) {
            try {
                mem.setData(addr, this.converter.getData());
                return this.converter.createResponse(null);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return this.converter.createErrorResponse(2);
            }
        }
        return this.converter.createErrorResponse(86);
    }

    public String getRecvMessage() {
        return Util.toString(this.converter.getRecvData());
    }

    public String getSendMessage() {
        return Util.toString(this.converter.getSendData());
    }
}

