/*
 * Decompiled with CFR 0.152.
 */
package jp.co.frdm.Vamp.emulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jp.co.frdm.Vamp.emulator.AbstractPlc;
import jp.co.frdm.Vamp.emulator.PlcMemory;
import jp.co.frdm.Vamp.emulator.converter.SNGW;

public class SYSNET
extends AbstractPlc {
    private Map memoryMap;
    private Map memKindMap;
    private SNGW converter;

    public byte[] recvPerformed(byte[] recvData) {
        if (!this.getStat()) {
            return null;
        }
        if (!this.converter.checkCommand(recvData)) {
            return null;
        }
        this.incCount();
        switch (this.converter.getCommandKind()) {
            case 0: {
                return this.commandRead();
            }
            case 4: {
                return this.commandRead();
            }
            case 10: {
                return this.commandRead();
            }
            case 1: {
                return this.commandWrite();
            }
            case 5: {
                return this.commandWrite();
            }
            case 11: {
                return this.commandWrite();
            }
        }
        return this.converter.getErrorResponse(1);
    }

    public void setPlcParam(StringTokenizer st) {
        this.converter = new SNGW(Integer.parseInt(st.nextToken("\t")), Integer.parseInt(st.nextToken("\t")), 0);
        this.memoryMap = new HashMap();
        this.memoryMap.put("CIO", new PlcMemory.PlcWordMemory(2555));
        this.memoryMap.put("HR", new PlcMemory.PlcWordMemory(2555));
        this.memoryMap.put("DM", new PlcMemory.PlcWordMemory(24576));
        this.memKindMap = new HashMap();
        this.memKindMap.put(new Integer(0), this.memoryMap.get("CIO"));
        this.memKindMap.put(new Integer(1), this.memoryMap.get("CIO"));
        this.memKindMap.put(new Integer(4), this.memoryMap.get("HR"));
        this.memKindMap.put(new Integer(5), this.memoryMap.get("HR"));
        this.memKindMap.put(new Integer(10), this.memoryMap.get("DM"));
        this.memKindMap.put(new Integer(11), this.memoryMap.get("DM"));
    }

    public String getPlcParam() {
        return this.getName() + "\t" + String.valueOf(this.getPortNo()) + "\tSYSNET\t" + this.converter.getParam() + "\t";
    }

    public String getPlcInfo() {
        return "SYSNET " + this.converter.getInfo();
    }

    public List getPlcMemNames() {
        ArrayList list = new ArrayList(this.memoryMap.keySet());
        Collections.sort(list);
        return list;
    }

    public void writePlcMem(String memName, int addr, byte[] data) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            mem.setData(addr, data);
        }
    }

    public byte[] readPlcMem(String memName, int addr, int wordLen) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            return mem.getData(addr, wordLen);
        }
        return null;
    }

    public int getPlcMemMax(String memName) {
        PlcMemory mem = (PlcMemory)this.memoryMap.get(memName);
        if (mem != null) {
            return mem.getAddressMax();
        }
        return 0;
    }

    private byte[] commandRead() {
        Integer kind = new Integer(this.converter.getMemoryKind());
        int addr = this.converter.getMemoryAdder();
        int wlen = this.converter.getWordLength();
        PlcMemory mem = (PlcMemory)this.memKindMap.get(kind);
        if (mem != null) {
            byte[] data = mem.getData(addr, wlen);
            if (data != null) {
                return this.converter.getResponse(data);
            }
            return this.converter.getErrorResponse(4);
        }
        return this.converter.getErrorResponse(2);
    }

    private byte[] commandWrite() {
        Integer kind = new Integer(this.converter.getMemoryKind());
        int addr = this.converter.getMemoryAdder();
        PlcMemory mem = (PlcMemory)this.memKindMap.get(kind);
        if (mem != null) {
            try {
                mem.setData(addr, this.converter.getData());
                return this.converter.getErrorResponse(0);
            }
            catch (IndexOutOfBoundsException ex) {
                return this.converter.getErrorResponse(4);
            }
        }
        return this.converter.getErrorResponse(2);
    }

    public String getRecvMessage() {
        byte[] data = this.converter.getRecvData();
        if (data != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 40 && i < data.length; ++i) {
                if (i == 13) {
                    sb.append("|");
                }
                sb.append(data[i]).append(" ");
            }
            return sb.toString();
        }
        return "no";
    }

    public String getSendMessage() {
        byte[] data = this.converter.getSendData();
        if (data != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 40 && i < data.length; ++i) {
                if (i == 13) {
                    sb.append("|");
                }
                sb.append(data[i]).append(" ");
            }
            return sb.toString();
        }
        return "no";
    }
}

