/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jimx.cyclicread;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataHolderGroup;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataProviderDoesNotSupportException;
import jp.gr.javacons.jim.DataReferenceMaintainer;
import jp.gr.javacons.jim.GroupDoesNotExistException;
import jp.gr.javacons.jim.Manager;

public class CyclicReadRequester
extends Component
implements DataReferenceMaintainer,
Runnable,
Serializable {
    static final long serialVersionUID = -4634333022406273608L;
    private long scanRate = 2000L;
    private boolean active = false;
    private boolean autoStart = true;
    private String[][] dataHoldersInfo = new String[0][0];
    private transient DataProviderWrapper[] dataProviderWrappers = new DataProviderWrapper[0];
    private transient Manager manager;
    private volatile transient Thread thread;
    protected String iconName = "CyclicReadRequester32.gif";
    private transient Image icon;

    public void addedAsDataReferenceMaintainer() {
        this.manager = Manager.getInstance();
        this.resetDataProviderWrappers();
        this.thread = new Thread(this);
        this.thread.start();
        if (!Beans.isDesignTime() && this.autoStart) {
            this.setActive(true);
        }
    }

    public void addNotify() {
        super.addNotify();
        Manager.getInstance().addDataReferenceMaintainer(this);
    }

    public void dataHolderAvailable(DataProvider dp, DataHolder[] dhs) {
        for (int i = 0; i < this.dataProviderWrappers.length; ++i) {
            DataProviderWrapper dpw = this.dataProviderWrappers[i];
            if (dp != dpw.dataProvider) continue;
            if (dpw.notExistingDataHolderNames.length == 0) {
                return;
            }
            for (int j = 0; j < dpw.notExistingDataHolderNames.length; ++j) {
                String dhn = dpw.notExistingDataHolderNames[j];
                for (int jj = 0; jj < dhs.length; ++jj) {
                    if (!dhn.equals(dhs[jj].getDataHolderName())) continue;
                    dpw.resetReadGroup(this.dataHoldersInfo[i]);
                    return;
                }
            }
            return;
        }
    }

    public void dataHolderRenamed(DataProvider dp, DataHolder dh, String newName, String oldName) {
        for (int i = 0; i < this.dataProviderWrappers.length; ++i) {
            int j;
            DataProviderWrapper dpw = this.dataProviderWrappers[i];
            if (dp != dpw.dataProvider) continue;
            for (j = 0; j < dpw.notExistingDataHolderNames.length; ++j) {
                String dhn = dpw.notExistingDataHolderNames[j];
                if (!newName.equals(dhn)) continue;
                dpw.resetReadGroup(this.dataHoldersInfo[i]);
                return;
            }
            for (j = 0; j < dpw.dataHolders.length; ++j) {
                if (dh != dpw.dataHolders[j]) continue;
                dpw.resetReadGroup(this.dataHoldersInfo[i]);
                return;
            }
            return;
        }
    }

    public void dataHolderRevoked(DataProvider dp, DataHolder[] dhs) {
        for (int i = 0; i < this.dataProviderWrappers.length; ++i) {
            DataProviderWrapper dpw = this.dataProviderWrappers[i];
            if (dp != dpw.dataProvider) continue;
            if (dpw.dataHolders.length == 0) {
                return;
            }
            for (int j = 0; j < dpw.dataHolders.length; ++j) {
                DataHolder dh = dpw.dataHolders[j];
                for (int jj = 0; jj < dhs.length; ++jj) {
                    if (dh != dhs[jj]) continue;
                    dpw.resetReadGroup(this.dataHoldersInfo[i]);
                    return;
                }
            }
            return;
        }
    }

    public void dataProviderAvailable(DataProvider dp, DataHolder[] dhs) {
        String dpn = dp.getDataProviderName();
        for (int i = 0; i < this.dataHoldersInfo.length; ++i) {
            if (!dpn.equals(this.dataHoldersInfo[i][0])) continue;
            this.dataProviderWrappers[i].resetReadGroup(this.dataHoldersInfo[i]);
            return;
        }
    }

    public void dataProviderRenamed(DataProvider dp, String newName, String oldName) {
        String nn = newName;
        String on = oldName;
        for (int i = 0; i < this.dataHoldersInfo.length; ++i) {
            if (nn.equals(this.dataHoldersInfo[i][0])) {
                this.dataProviderWrappers[i].resetReadGroup(this.dataHoldersInfo[i]);
                nn = null;
                if (on == null) {
                    return;
                }
            }
            if (!on.equals(this.dataHoldersInfo[i][0])) continue;
            this.dataProviderWrappers[i].resetReadGroup(this.dataHoldersInfo[i]);
            on = null;
            if (nn != null) continue;
            return;
        }
    }

    public void dataProviderRevoked(DataProvider dp, DataHolder[] dhs) {
        String dpn = dp.getDataProviderName();
        for (int i = 0; i < this.dataHoldersInfo.length; ++i) {
            if (!dpn.equals(this.dataHoldersInfo[i][0])) continue;
            this.dataProviderWrappers[i].resetReadGroup(this.dataHoldersInfo[i]);
            return;
        }
    }

    public String[][] getDataHoldersInfo() {
        return this.dataHoldersInfo;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(32, 32);
    }

    public long getScanRate() {
        return this.scanRate;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (Beans.isDesignTime()) {
            if (this.icon == null && this.iconName != null) {
                try {
                    URL url = this.getClass().getResource(this.iconName);
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    this.icon = tk.createImage((ImageProducer)url.getContent());
                }
                catch (Exception ex) {
                    this.icon = null;
                }
            }
            if (this.icon != null) {
                g.drawImage(this.icon, 0, 0, this);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.dataProviderWrappers = new DataProviderWrapper[0];
    }

    public void removedAsDataReferenceMaintainer() {
        this.stop();
        this.dataProviderWrappers = new DataProviderWrapper[0];
        this.manager = null;
    }

    public void removeNotify() {
        Manager.getInstance().removeDataReferenceMaintainer(this);
        super.removeNotify();
    }

    private void resetDataProviderWrappers() {
        if (this.manager != null) {
            this.dataProviderWrappers = new DataProviderWrapper[this.dataHoldersInfo.length];
            for (int i = 0; i < this.dataHoldersInfo.length; ++i) {
                this.dataProviderWrappers[i] = new DataProviderWrapper(this.dataHoldersInfo[i]);
            }
        } else {
            this.dataProviderWrappers = new DataProviderWrapper[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.thread == thisThread) {
            try {
                if (!this.active) {
                    CyclicReadRequester cyclicReadRequester = this;
                    synchronized (cyclicReadRequester) {
                        while (!this.active) {
                            this.wait();
                        }
                    }
                }
                for (int i = 0; i < this.dataProviderWrappers.length; ++i) {
                    this.dataProviderWrappers[i].read();
                }
                Thread.sleep(this.scanRate);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void setActive(boolean active) {
        if (!this.active && active) {
            this.active = true;
            this.notifyAll();
        } else if (this.active && !active) {
            this.active = false;
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, 32, 32);
    }

    public void setDataHoldersInfo(String[][] dhsInfo) {
        this.dataHoldersInfo = dhsInfo;
        this.resetDataProviderWrappers();
    }

    public void setScanRate(long millis) {
        if (millis > 0L) {
            this.scanRate = millis;
        }
    }

    protected synchronized void stop() {
        Thread t = this.thread;
        this.thread = null;
        t.interrupt();
    }

    private class DataProviderWrapper {
        private DataProvider dataProvider;
        private DataHolderGroup readGroup;
        private String[] notExistingDataHolderNames;
        private DataHolder[] dataHolders;

        DataProviderWrapper(String[] dpDhsNames) {
            this.resetReadGroup(dpDhsNames);
        }

        void resetReadGroup(String[] dpDhsNames) {
            if (CyclicReadRequester.this.manager == null) {
                this.dataProvider = null;
                this.readGroup = null;
                this.notExistingDataHolderNames = null;
                this.dataHolders = null;
                return;
            }
            DataProvider oldDp = this.dataProvider;
            this.dataProvider = CyclicReadRequester.this.manager.getDataProvider(dpDhsNames[0]);
            if (oldDp != null && this.readGroup != null) {
                try {
                    oldDp.deleteReadGroup(this.readGroup);
                }
                catch (DataProviderDoesNotSupportException e) {
                    // empty catch block
                }
            }
            if (this.dataProvider == null) {
                return;
            }
            Vector<DataHolder> dhs = new Vector<DataHolder>();
            Vector<String> nedhns = new Vector<String>();
            for (int i = 1; i < dpDhsNames.length; ++i) {
                DataHolder dh = this.dataProvider.getDataHolder(dpDhsNames[i]);
                if (dh != null) {
                    dhs.addElement(dh);
                    continue;
                }
                nedhns.addElement(dpDhsNames[i]);
            }
            this.dataHolders = new DataHolder[dhs.size()];
            dhs.copyInto(this.dataHolders);
            this.notExistingDataHolderNames = new String[nedhns.size()];
            nedhns.copyInto(this.notExistingDataHolderNames);
            try {
                this.readGroup = this.dataProvider.createReadGroup(this.dataHolders);
            }
            catch (DataProviderDoesNotSupportException e) {
                // empty catch block
            }
        }

        void read() {
            if (this.readGroup != null) {
                try {
                    try {
                        this.dataProvider.asyncRead(this.readGroup);
                        return;
                    }
                    catch (NullPointerException e) {
                        return;
                    }
                    catch (GroupDoesNotExistException ee) {
                        this.readGroup = this.dataProvider.createReadGroup(this.dataHolders);
                        try {
                            this.dataProvider.asyncRead(this.readGroup);
                        }
                        catch (GroupDoesNotExistException eee) {
                            System.out.println("GroupDoesNotExistException for asyncRead(dhg) with newly created dhg");
                        }
                        return;
                    }
                }
                catch (DataProviderDoesNotSupportException ee) {
                    System.out.println("DataProviderDoesNotSupportException for asyncRead(dhg)");
                    return;
                }
            }
        }
    }
}

