/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.Table;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.filter.DefaultColumnFilter;

public class Compare
extends AbstractStep {
    private static final String DEFAULT_FORMAT = "flat";
    private String _format;
    private File _src;
    private List _tables = new ArrayList();
    private boolean _sort = false;

    public File getSrc() {
        return this._src;
    }

    public void setSrc(File src) {
        this._src = src;
    }

    public void setSort(boolean sort) {
        this._sort = sort;
    }

    public String getFormat() {
        return this._format != null ? this._format : DEFAULT_FORMAT;
    }

    public void setFormat(String format) {
        if (!(format.equalsIgnoreCase(DEFAULT_FORMAT) || format.equalsIgnoreCase("xml") || format.equalsIgnoreCase("csv"))) {
            throw new IllegalArgumentException("Type must be either 'flat'(default) csv or 'xml' but was: " + format);
        }
        this._format = format;
    }

    public List getTables() {
        return this._tables;
    }

    public void addTable(Table table) {
        this._tables.add(table);
    }

    public void addQuery(Query query) {
        this._tables.add(query);
    }

    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        IDataSet expectedDataset = this.getSrcDataSet(this._src, this.getFormat(), false);
        IDataSet actualDataset = this.getDatabaseDataSet(connection, this._tables, false);
        String[] tableNames = null;
        tableNames = this._tables.size() == 0 ? expectedDataset.getTableNames() : actualDataset.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            String tableName = tableNames[i];
            ITable expectedTable = expectedDataset.getTable(tableName);
            ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
            ITable actualTable = actualDataset.getTable(tableName);
            actualTable = DefaultColumnFilter.includedColumnsTable(actualTable, expectedMetaData.getColumns());
            if (this._sort) {
                expectedTable = new SortedTable(expectedTable);
                actualTable = new SortedTable(actualTable);
            }
            Assertion.assertEquals(expectedTable, actualTable);
        }
    }

    public String getLogMessage() {
        return "Executing compare: \n          from file: " + (this._src == null ? null : this._src.getAbsolutePath()) + "\n          with format: " + this._format;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Compare: ");
        result.append(" src=" + this._src.getAbsolutePath());
        result.append(", format= " + this._format);
        result.append(", tables= " + this._tables);
        return result.toString();
    }
}

