/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.LowerCaseTableMetaData;

public class LowerCaseDataSet
extends AbstractDataSet {
    private final IDataSet _dataSet;

    public LowerCaseDataSet(ITable table) throws DataSetException {
        this(new DefaultDataSet(table));
    }

    public LowerCaseDataSet(ITable[] tables) throws DataSetException {
        this(new DefaultDataSet(tables));
    }

    public LowerCaseDataSet(IDataSet dataSet) throws DataSetException {
        this._dataSet = dataSet;
    }

    private ITable createLowerTable(ITable table) throws DataSetException {
        return new CompositeTable((ITableMetaData)new LowerCaseTableMetaData(table.getTableMetaData()), table);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new LowerCaseIterator(reversed ? this._dataSet.reverseIterator() : this._dataSet.iterator());
    }

    public String[] getTableNames() throws DataSetException {
        String[] tableNames = super.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            tableNames[i] = tableNames[i].toLowerCase();
        }
        return tableNames;
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        return new LowerCaseTableMetaData(super.getTableMetaData(tableName));
    }

    public ITable getTable(String tableName) throws DataSetException {
        return this.createLowerTable(super.getTable(tableName));
    }

    private class LowerCaseIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public LowerCaseIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            return this._iterator.next();
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return new LowerCaseTableMetaData(this._iterator.getTableMetaData());
        }

        public ITable getTable() throws DataSetException {
            return LowerCaseDataSet.this.createLowerTable(this._iterator.getTable());
        }
    }
}

