package jp.gr.java_conf.skrb.gui.lattice;

import java.awt.Insets;

/**
 * LatticeConstraints NX LatticeLayout NXp̐NXłB
 * 
 * @see LatticeLayout
 */
public class LatticeConstraints implements Cloneable, java.io.Serializable {
	private static final long serialVersionUID = 7717871975607487221L;

	/**
	 * R|[lg x W
	 * ftHg 0
	 */
	public int x;

	/**
	 * R|[lg y W
	 * ftHg 0
	 */
	public int y;

	/**
	 * R|[lg̕\̈敝
	 * ftHg 1
	 */
	public int width;

	/**
	 * R|[lg̕\̈捂
	 * ftHg 1
	 */
	public int height;

	/**
	 * R|[lg\̈敝菬ꍇA`̎wɎgp
	 * LEFT, CENTER, RIGHT ̂ꂩlƂ
	 * ftHg LEFT
	 */
	public int halign;

	/**
	 * R|[lg\̈捂菬ꍇA`̎wɎgp
	 * TOP, CENTER, BOTTOM ̂ꂩlƂ
	 * ftHg TOP
	 */
	public int valign;

	/**
	 * R|[lg\̈菬ꍇAg\sǂw肷
	 * NONE, HORIZONTAL, VERTICAL, BOTH ̂ꂩlƂ
	 * ftHg NONE
	 */
	public int fill;

	/**
	 * R|[lg\̈傫ꍇAk\sǂw肷
	 * NONE, HORIZONTAL, VERTICAL, BOTH ̂ꂩlƂ
	 * ftHg NONE
	 */
	public int adjust;

	/**
	 * ̗]
	 * ftHg 0
	 */
	public int left;

	/**
	 * E̗]
	 * ftHg 0
	 */
	public int right;

	/**
	 * 㕔̗]
	 * ftHg 0
	 */
	public int top;

	/**
	 * ̗]
	 * ftHg 0
	 */
	public int bottom;

	/**
	 * fill  adjust Ŏgp萔BgEkȂꍇ
	 */
	public final static int NONE = -1;

	/**
	 * fill  adjust Ŏgp萔BgEkcEɍsꍇ
	 */
	public final static int BOTH = 0;

	/**
	 * fill  adjust Ŏgp萔Bc̊gEksꍇ
	 */
	public final static int VERTICAL = 1;

	/**
	 * fill  adjust Ŏgp萔B̊gEksꍇ
	 */
	public final static int HORIZONTAL = 2;

	/**
	 * halign  valign Ŏgp萔Bɕ\ꍇ
	 */
	public final static int CENTER = 0;

	/**
	 * valign Ŏgp萔Btŕ\ꍇ
	 */
	public final static int TOP = 1;

	/**
	 * valign Ŏgp萔Btŕ\ꍇ
	 */
	public final static int BOTTOM = 2;

	/**
	 * halign Ŏgp萔Blŕ\ꍇ
	 */
	public final static int LEFT = 3;

	/**
	 * halign Ŏgp萔BElŕ\ꍇ
	 */
	public final static int RIGHT = 4;

	/**
	 * SĂftHglŐRXgN^
	 */
	public LatticeConstraints() {
		this(0, 0, 1, 1, LEFT, TOP, NONE, NONE, 0, 0, 0, 0);
	}

	public LatticeConstraints(int x, int y, int width, int height) {
		this(x, y, width, height, LEFT, TOP, NONE, NONE, 0, 0, 0, 0);
	}

	public LatticeConstraints(
		int x,
		int y,
		int width,
		int height,
		Insets insets) {
		this(
			x,
			y,
			width,
			height,
			LEFT,
			TOP,
			NONE,
			NONE,
			insets.top,
			insets.left,
			insets.bottom,
			insets.right);
	}

	public LatticeConstraints(
		int x,
		int y,
		int width,
		int height,
		int fill,
		int adjust,
		Insets insets) {
		this(
			x,
			y,
			width,
			height,
			LEFT,
			TOP,
			fill,
			adjust,
			insets.top,
			insets.left,
			insets.bottom,
			insets.right);
	}

	public LatticeConstraints(
		int x,
		int y,
		int width,
		int height,
		int halign,
		int valign,
		int fill,
		int adjust,
		Insets insets) {
		this(
			x,
			y,
			width,
			height,
			valign,
			halign,
			fill,
			adjust,
			insets.top,
			insets.left,
			insets.bottom,
			insets.right);
	}

	/**
	 * SẴvpeBw肵ĐRXgN^
	 */
	public LatticeConstraints(
		int x,
		int y,
		int width,
		int height,
		int halign,
		int valign,
		int fill,
		int adjust,
		int top,
		int left,
		int bottom,
		int right) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.halign = halign;
		this.valign = valign;
		this.fill = fill;
		this.adjust = adjust;
		this.top = top;
		this.left = left;
		this.bottom = bottom;
		this.right = right;
	}

	/**
	 * IuWFNg̕쐬
	 */
	public Object clone() {
		try {
			LatticeConstraints c = (LatticeConstraints) super.clone();
			return c;
		} catch (CloneNotSupportedException e) {
			throw new InternalError();
		}
	}

	/**
	 * ւ̕ύX
	 */
	public String toString() {
		String fillStr = "";
		switch (fill) {
			case NONE :
				fillStr = "none";
				break;
			case BOTH :
				fillStr = "both";
				break;
			case VERTICAL :
				fillStr = "vertical";
				break;
			case HORIZONTAL :
				fillStr = "horizontal";
				break;
		}

		String adjustStr = "";
		switch (adjust) {
			case NONE :
				adjustStr = "none";
				break;
			case BOTH :
				adjustStr = "both";
				break;
			case VERTICAL :
				adjustStr = "vertical";
				break;
			case HORIZONTAL :
				adjustStr = "horizontal";
				break;
		}

		String halignStr = "";
		switch (halign) {
			case LEFT :
				halignStr = "left";
				break;
			case CENTER :
				halignStr = "center";
				break;
			case RIGHT :
				halignStr = "right";
				break;
		}

		String valignStr = "";
		switch (valign) {
			case TOP :
				valignStr = "top";
				break;
			case CENTER :
				valignStr = "center";
				break;
			case BOTTOM :
				valignStr = "bottom";
				break;
		}

		return "LatticeConstraints [x: "
			+ x
			+ " y: "
			+ y
			+ " width: "
			+ width
			+ " height: "
			+ height
			+ " halign: "
			+ halignStr
			+ " valign: "
			+ valignStr
			+ " fill: "
			+ fillStr
			+ " adjust: "
			+ adjustStr
			+ " top: "
			+ top
			+ " left: "
			+ left
			+ " bottom: "
			+ bottom
			+ " right: "
			+ right
			+ "]";
	}
}
