/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/applet/graph/bargraph/Attic/YearBarGraphView.java,v 1.1.2.2 2007/04/24 00:46:32 frdm Exp $
 * $Revision: 1.1.2.2 $
 * $Date: 2007/04/24 00:46:32 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.applet.graph.bargraph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.Format;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

import org.F11.scada.applet.graph.DefaultSelectiveGraphModel;
import org.F11.scada.applet.graph.GraphModel;
import org.F11.scada.applet.graph.GraphPropertyModel;
import org.F11.scada.applet.graph.LoggingData;
import org.F11.scada.applet.symbol.ColorFactory;
import org.F11.scada.server.register.HolderString;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/**
 * _OtR|[lgNXłB
 * 
 * @author Youhei Horikawa <hori@users.sourceforge.jp>
 */
public class YearBarGraphView extends Box {
	private static final long serialVersionUID = -8630686458331941049L;
	/** MOAPI */
	private static Logger logger;
	private static final Format format = FastDateFormat
			.getInstance("yyyy/MM/dd HH:mm");

	public YearBarGraphView(
			GraphModel graphModel,
			GraphPropertyModel graphPropertyModel,
			String barstep,
			int axismode) throws IOException, SAXException {
		super(BoxLayout.Y_AXIS);
		logger = Logger.getLogger(getClass().getName());

		BarGraphStep barGraphStep = BarGraphStep.createBarGraphStep(
				barstep,
				graphPropertyModel.getHorizontalScaleWidth());

		FillGraph graph = new FillGraph(
				graphModel,
				graphPropertyModel,
				barGraphStep,
				axismode);
		BarGraphScrollBar scrollBar = new BarGraphScrollBar(graph);
		scrollBar.addAdjustmentListener(graph);
		add(graph, BorderLayout.CENTER);
		add(scrollBar, BorderLayout.SOUTH);
	}

	/**
	 * _OtR|[lgNX
	 */
	private static class FillGraph extends JComponent implements
			AdjustmentListener, PropertyChangeListener {
		private static final long serialVersionUID = 5398372942534990318L;
		/** Otf[^f */
		private GraphModel graphModel;
		/** OtvpeBf */
		private GraphPropertyModel graphPropertyModel;
		/** f[^lƃOt`̔䗦 */
		private double[] yScale;
		/** Ot̃IW */
		private Point[] origin;
		/** Ot\F */
		private Color[] graphColors;

		/** ݕ\Ăf[^̃X^[gCfbNX */
		private int currentStartIndex;
		/** ݕ\ĂXڐ̃Xg */
		private List currentAxisList;
		/** Ot`̈ */
		private Rectangle graphViewBounds;
		/** Qƒl X^CX^v */
		private Timestamp referenceValueTimestamp;
		/** Qƒl\tO */
		private boolean referenceValueFlag;
		/** OtXebv */
		private BarGraphStep barGraphStep;
		/** ڐ`惂[h */
		private int axismode;

		/**
		 * RXgN^
		 * 
		 * @param graphPropertyModel OtvpeBEf̎Q
		 */
		public FillGraph(
				GraphModel graphModel,
				GraphPropertyModel graphPropertyModel,
				BarGraphStep barGraphStep,
				int axismode) throws IOException, SAXException {
			super();
			this.graphModel = graphModel;
			this.graphPropertyModel = graphPropertyModel;
			this.graphPropertyModel.addPropertyChangeListener(this);
			this.graphPropertyModel.addPropertyChangeListener(
					GraphPropertyModel.GROUP_CHANGE_EVENT,
					this);
			this.addMouseListener(new FillGraphMouseListener(this));
			this.barGraphStep = barGraphStep;
			this.axismode = axismode;

			updateGraphModel();

			graphColors = graphPropertyModel.getColors();
			setDoubleBuffered(true);
			changeDisplayData();
			rescale();
		}

		private void updateGraphModel() {
			ArrayList holderStrings = new ArrayList(graphPropertyModel
					.getSeriesSize());
			for (int i = 0, s = graphPropertyModel.getSeriesSize(); i < s; i++) {
				HolderString hs = new HolderString();
				hs.setProvider(graphPropertyModel.getDataProviderName(i));
				hs.setHolder(graphPropertyModel.getDataHolderName(i));
				holderStrings.add(hs);
			}
			try {
				setModel(new DefaultSelectiveGraphModel(graphPropertyModel
						.getListHandlerName(), holderStrings, null));
			} catch (RemoteException e) {
				e.printStackTrace();
			}
			referenceValueTimestamp = graphPropertyModel.getReferenceTime(0);
		}

		/**
		 * 擪f[^̎擾܂B
		 */
		private long getStartTime() {
			Timestamp startTimestamp;
			try {
				startTimestamp = (Timestamp) graphModel
						.firstKey(graphPropertyModel.getListHandlerName());
			} catch (NoSuchElementException ex) {
				// f[^
				startTimestamp = new Timestamp(System.currentTimeMillis());
			}
			long startTime = barGraphStep.omitTime(startTimestamp.getTime());
			long startMinTime = getEndTime()
					- graphPropertyModel.getHorizontalScaleCount()
					* graphPropertyModel.getHorizontalScaleWidth()
					* (graphPropertyModel.getFoldCount() + 1)
					+ graphPropertyModel.getHorizontalScaleWidth();
			if (startMinTime < startTime)
				return startMinTime;
			return startTime;
		}

		/**
		 * ŏIf[^̎擾܂B
		 */
		private long getEndTime() {
			Timestamp endTimestamp;
			try {
				endTimestamp = (Timestamp) graphModel
						.lastKey(graphPropertyModel.getListHandlerName());
			} catch (NoSuchElementException ex) {
				// f[^
				endTimestamp = new Timestamp(System.currentTimeMillis());
			}
			return barGraphStep.omitTime(endTimestamp.getTime());
		}

		/**
		 * Jg̎擾܂B
		 */
		private long getCurrentTime() {
			return getStartTime() + currentStartIndex
					* graphPropertyModel.getHorizontalScaleWidth();
		}

		/**
		 * ʕ\f[^ύX܂B
		 */
		private void changeDisplayData() {
			int scaleCount = graphPropertyModel.getHorizontalScaleCount();
			currentAxisList = new ArrayList();
			// ON1\
			Calendar cal = Calendar.getInstance();
			cal.set(Calendar.MILLISECOND, 0);
			cal.set(Calendar.SECOND, 0);
			cal.set(Calendar.MINUTE, 0);
			cal.set(Calendar.HOUR_OF_DAY, 0);
			cal.set(Calendar.DATE, 1);
			cal.set(Calendar.MONTH, Calendar.JANUARY);
			cal.add(Calendar.YEAR, -1);
			for (int i = 0; i <= scaleCount; i++, cal.add(Calendar.MONTH, 1)) {
				currentAxisList.add(cal.getTime());
			}
		}

		/**
		 * R|[lg`悵܂B
		 * 
		 * @param g OtBbNReLXg
		 */
		public void paintComponent(Graphics g) {
			super.paintComponent(g);
			Graphics2D g2d = (Graphics2D) g.create();

			// XP[`
			drawAxis(g2d);
			// MOf[^`
			drawSeries(g2d);
			// Qƒl̔j`
			drawReference(g2d);

			g2d.dispose();
		}

		/**
		 * őlEŏl`ϊZo܂B
		 */
		private void rescale() {
			int scaleOneHeight = graphPropertyModel.getVerticalScaleHeight();
			int scaleCount = graphPropertyModel.getVerticalScaleCount();
			Insets scaleInsets = graphPropertyModel.getGraphiViewInsets();
			// Yƃf[^̔䗦Zo
			yScale = new double[graphPropertyModel.getSeriesSize()];
			origin = new Point[graphPropertyModel.getSeriesSize()];
			for (int i = 0; i < graphPropertyModel.getSeriesSize(); i++) {
				yScale[i] = (double) (scaleOneHeight * scaleCount)
						/ (graphPropertyModel.getVerticalMaximum(i) - graphPropertyModel
								.getVerticalMinimum(i));
				origin[i] = new Point(scaleInsets.left, scaleInsets.top
						+ scaleOneHeight
						* scaleCount
						+ (int) Math.round(graphPropertyModel
								.getVerticalMinimum(i)
								* yScale[i]));
			}
			repaint();
		}

		/**
		 * XP[EObhEڐ蓙`悵܂B
		 * 
		 * @param g OtBbNReLXg
		 */
		private void drawAxis(Graphics2D g2d) {
			int scaleOneHeight = graphPropertyModel.getVerticalScaleHeight();
			int scaleCount = graphPropertyModel.getVerticalScaleCount();
			int scaleCountWidth = graphPropertyModel.getHorizontalScaleCount();
			Insets scaleInsets = graphPropertyModel.getGraphiViewInsets();
			// ẌʒuZo
			Point baseOrigin = new Point(scaleInsets.left, scaleInsets.top
					+ scaleOneHeight * scaleCount);

			// wilCr[
			g2d.setColor(ColorFactory.getColor("navy"));
			graphViewBounds = new Rectangle(this.getSize());
			graphViewBounds.y = scaleInsets.top / 2;
			graphViewBounds.height = baseOrigin.y
					+ graphPropertyModel.getScaleOneHeightPixel()
					- scaleInsets.top / 2;
			g2d.fill(graphViewBounds);
			logger.debug("graphViewBounds : " + graphViewBounds);
			// F𔒂
			g2d.setColor(ColorFactory.getColor("white"));
			// X`
			long currentTime = getCurrentTime();
			long scaleOneTime = graphPropertyModel.getHorizontalScaleWidth();
			int scaleOneWidth = graphPropertyModel.getHorizontalPixcelWidth()
					/ scaleCountWidth;
			g2d.drawLine(baseOrigin.x, baseOrigin.y, baseOrigin.x
					+ (int) getXtime(currentTime + scaleOneTime
							* scaleCountWidth), baseOrigin.y);
			// Xڐ`
			FontMetrics metrics = g2d.getFontMetrics();
			int strHeight = metrics.getHeight();
			long time = 0;
			Iterator it = currentAxisList.iterator();
			Format format = FastDateFormat.getInstance("MM");
			for (int sc = 0; sc < scaleCountWidth; sc++) {
				Date timestamp = (Date) it.next();
				// `F𔒂
				g2d.setColor(ColorFactory.getColor("white"));
				// ڐ̐`
				int x = baseOrigin.x + (int) getXtime(currentTime + time);
				g2d.drawLine(x, baseOrigin.y, x, baseOrigin.y
						+ graphPropertyModel.getScaleOneHeightPixel());
				// ڐ̊ԂɓtƎԂ`
				g2d.setColor(ColorFactory.getColor("white"));
				if (axismode == 1) {
					// PڐuɂQs`
					if (sc % 2 != scaleCountWidth % 2) { // ŐVɕK`悷
						String timeString = format.format(timestamp);
						int strWidth = metrics.stringWidth(timeString);
						g2d.drawString(timeString, x + scaleOneWidth / 2
								- strWidth / 2, baseOrigin.y
								+ graphPropertyModel.getScaleOneHeightPixel()
								+ strHeight);
						timeString = format.format(timestamp);
						strWidth = metrics.stringWidth(timeString);
						g2d.drawString(timeString, x + scaleOneWidth / 2
								- strWidth / 2, baseOrigin.y
								+ graphPropertyModel.getScaleOneHeightPixel()
								+ strHeight * 2);
					}
				} else {
					String timeString = format.format(timestamp);
					int strWidth = metrics.stringWidth(timeString);
					g2d.drawString(timeString, x + scaleOneWidth / 2 - strWidth
							/ 2, baseOrigin.y
							+ graphPropertyModel.getScaleOneHeightPixel()
							+ strHeight);
				}
				time += scaleOneTime;
			}

			// Xg[NjɕύX
			float[] dash = { 3.1f };
			BasicStroke bs = new BasicStroke(
					1.0f,
					BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_MITER,
					10.0f,
					dash,
					0.0f);
			g2d.setStroke(bs);
			g2d.setColor(ColorFactory.getColor("cornflowerblue"));
			int x = (int) getXtime(currentTime + scaleOneTime * scaleCountWidth);
			for (int i = baseOrigin.y - scaleOneHeight; i >= scaleInsets.top; i -= scaleOneHeight) {
				g2d.drawLine(baseOrigin.x, i, baseOrigin.x + x, i);
			}
		}

		/**
		 * OtXWɕϊ܂B
		 * 
		 * @param timep 
		 * @return XW
		 */
		private double getXtime(long time) {
			long offsTime = time - getCurrentTime();
			long fullScale = graphPropertyModel.getHorizontalScaleWidth()
					* graphPropertyModel.getHorizontalScaleCount();
			return offsTime * graphPropertyModel.getHorizontalPixcelWidth()
					/ fullScale;
		}

		private LoggingData findLoggingData(long findTime, String handlerName) {
			LoggingData loggingData;
			graphModel.findRecord(handlerName, new Timestamp(findTime));
			if (!graphModel.next(handlerName))
				return null;
			loggingData = (LoggingData) graphModel.get(handlerName);
			if (findTime != barGraphStep.omitTime(loggingData.getTimestamp()
					.getTime())) {
				if (!graphModel.next(handlerName))
					return null;
				loggingData = (LoggingData) graphModel.get(handlerName);
				if (findTime != barGraphStep.omitTime(loggingData
						.getTimestamp().getTime()))
					return null;
			}
			return loggingData;
		}

		private void drawSeries(Graphics2D g2d) {
			// Jnɍł߂R[hoiw莞ԂPÕR[h܂ށj
			long scaleOneTime = graphPropertyModel.getHorizontalScaleWidth();
			long scaleCount = graphPropertyModel.getHorizontalScaleCount();
			long scaleFoldTime = scaleOneTime * scaleCount;
			int barWidth = graphPropertyModel.getHorizontalPixcelWidth()
					/ barGraphStep.getBarCount(scaleFoldTime)
					/ (graphPropertyModel.getFoldCount() + 2);
			long currentTime = getCurrentTime();

			if (logger.isDebugEnabled()) {
				logger.debug("draw BAR curtime : "
						+ format.format(new Date(currentTime)));
			}
			// BAR̕`
			Calendar cal = Calendar.getInstance();
			cal.set(Calendar.MILLISECOND, 0);
			cal.set(Calendar.SECOND, 0);
			cal.set(Calendar.MINUTE, 0);
			cal.set(Calendar.HOUR_OF_DAY, 0);
			cal.set(Calendar.DATE, 1);
			cal.set(Calendar.MONTH, Calendar.JANUARY);
			cal.add(Calendar.YEAR, -1);
			for (int fold = 0; fold <= graphPropertyModel.getFoldCount(); fold++) {
				for (int sc = 0; sc < graphPropertyModel
						.getHorizontalScaleCount(); sc++) {
					long keyTime = cal.getTimeInMillis();
					cal.add(Calendar.MONTH, 1);
					LoggingData loggingData = findLoggingData(
							keyTime,
							graphPropertyModel.getListHandlerName());
					if (loggingData != null) {
						double xTime1 = getXtime(currentTime + scaleOneTime
								* sc);

						loggingData.first();
						double item1 = loggingData.next();
						Point p = dataToPoint(xTime1, item1, 0);
						Point p2 = dataToPoint(xTime1, 0.0, 0);
						Rectangle rect = new Rectangle(p);
						g2d.setColor(graphColors[fold]);
						rect.x += fold * barWidth + barWidth / 2;
						rect.setSize(barWidth - 1, p2.y - p.y);
						invalidateLineY(rect);
						g2d.fill(rect);
					}
				}
			}
		}

		private void invalidateLineY(Rectangle rec) {
			int graphHeight = graphViewBounds.y + graphViewBounds.height
					- graphPropertyModel.getScaleOneHeightPixel();
			int total = rec.y + rec.height;
			if (total > graphHeight) {
				rec.height -= total - graphHeight;
			}
		}

		/**
		 * f[^OtWɕϊ܂B
		 * 
		 * @param x XW
		 * @param y V[Yf[^
		 * @param series V[Y
		 * @return `悷|Cg
		 */
		private Point dataToPoint(double x, double y, int series) {
			return new Point((int) Math.round(origin[series].x + x), (int) Math
					.round(origin[series].y - yScale[series] * y));
		}

		public Dimension getPreferredSize() {
			int scaleOneHeight = graphPropertyModel.getVerticalScaleHeight();
			int scaleCount = graphPropertyModel.getVerticalScaleCount();
			int scaleOneWidth = graphPropertyModel.getHorizontalPixcelWidth()
					/ graphPropertyModel.getHorizontalScaleCount();
			Insets scaleInsets = graphPropertyModel.getGraphiViewInsets();

			return new Dimension(
					scaleInsets.left + scaleInsets.right + scaleOneWidth
							* graphPropertyModel.getHorizontalScaleCount(),
					scaleInsets.top + scaleInsets.bottom + scaleOneHeight
							* scaleCount);
		}

		/**
		 * Qƒl̔j`揈
		 * 
		 * @param g OtBbNReLXg
		 */
		private void drawReference(Graphics2D g2d) {
			if (!referenceValueFlag) {
				return;
			}

			// Ot\X߂
			Calendar cal = Calendar.getInstance();
			cal.setTime(referenceValueTimestamp);
			int month = cal.get(Calendar.MONTH);
			long scaleCount = graphPropertyModel.getHorizontalScaleCount();
			int barWidth = (int) (graphPropertyModel.getHorizontalPixcelWidth() / scaleCount);
			int referenceValue = graphPropertyModel.getGraphiViewInsets().left
					+ month * barWidth;
			if (isNotReferenceDraw(referenceValue)) {
				return;
			}

			// Xg[NjɕύX
			float[] dash = { 16.0f, 4.0f };
			BasicStroke bs = new BasicStroke(
					1.0f,
					BasicStroke.CAP_BUTT,
					BasicStroke.JOIN_MITER,
					10.0f,
					dash,
					0.0f);
			g2d.setStroke(bs);
			g2d.setColor(ColorFactory.getColor("white"));
			if (logger.isDebugEnabled()) {
				logger.debug("referenceValue=" + referenceValue + " barWidth="
						+ barWidth);
			}
			g2d.drawRect(
					referenceValue,
					graphViewBounds.y,
					barWidth - 1,
					graphViewBounds.height);
		}

		private boolean isNotReferenceDraw(int referenceValue) {
			Insets insets = graphPropertyModel.getGraphiViewInsets();
			logger.debug("referenceValue : "
					+ referenceValue
					+ " left : "
					+ insets.left
					+ " right : "
					+ (insets.left + graphPropertyModel
							.getHorizontalPixcelWidth()));
			if (referenceValue < insets.left
					|| referenceValue > (insets.left + graphPropertyModel
							.getHorizontalPixcelWidth())) {
				return true;
			}
			return false;
		}

		public Dimension getMaximumSize() {
			return getPreferredSize();
		}

		public Dimension getMinimumSize() {
			return getPreferredSize();
		}

		public GraphModel getModel() {
			return this.graphModel;
		}

		public void setModel(GraphModel model) {
			setModel(model, true);
		}

		private void setModel(GraphModel model, boolean withRescale) {
			if (model == null) {
				throw new IllegalArgumentException(
						"Cannot set a null GraphModel.");
			}

			if (graphModel != model) {
				GraphModel old = graphModel;
				if (old != null) {
					old.removePropertyChangeListener(this);
					old.stop();
				}
				graphModel = model;
				graphModel.addPropertyChangeListener(this);
				if (withRescale) {
					rescale();
				}
				firePropertyChange("model", old, this.graphModel);
			}
		}

		public void adjustmentValueChanged(AdjustmentEvent e) {
			currentStartIndex = e.getValue();
			if (logger.isDebugEnabled()) {
				logger.debug("value : " + e.getValue());
			}
			changeDisplayData();
			repaint();
		}

		public void propertyChange(PropertyChangeEvent evt) {
			if (GraphPropertyModel.GROUP_CHANGE_EVENT.equals(evt
					.getPropertyName())) {
				updateGraphModel();
			}
			changeDisplayData();
			rescale();
		}

		/**
		 * Ot`GÃ}EXXi[A_v^[NXłB QƒlZo܂B
		 */
		private static class FillGraphMouseListener extends MouseAdapter {
			private FillGraph fillGraph;

			FillGraphMouseListener(FillGraph fillGraph) {
				this.fillGraph = fillGraph;
			}

			public void mouseReleased(MouseEvent e) {
				Point point = e.getPoint();
				if (fillGraph.graphViewBounds.contains(point)) {
					// Qƒl\tO𗧂Ă
					fillGraph.referenceValueFlag = true;

					// NbNꂽ X WA̎ԂZo
					long scaleCount = fillGraph.graphPropertyModel
							.getHorizontalScaleCount();
					long scaleOneWidth = fillGraph.graphPropertyModel
							.getHorizontalPixcelWidth()
							/ scaleCount;
					int clickIndex = (point.x - fillGraph.graphPropertyModel
							.getGraphiViewInsets().left)
							/ (int) scaleOneWidth;
					clickIndex = Math.min(clickIndex, 11);
					long referenceValue = getReferenceValue(clickIndex);
					fillGraph.referenceValueTimestamp = new Timestamp(
							referenceValue);

					// ZoԂA܂Ԃf[^B
					Calendar cal = Calendar.getInstance();
					cal.setTimeInMillis(referenceValue);
					for (int fold = 0; fold <= fillGraph.graphPropertyModel
							.getFoldCount(); fold++) {
						// ZoԂAV[Yf[^
						long keyTime = 0;
						if (0 < fold) {
							cal.add(Calendar.YEAR, fold);
							keyTime = cal.getTimeInMillis();
						} else {
							keyTime = referenceValue;
						}
						LoggingData loggingData = fillGraph.findLoggingData(
								keyTime,
								fillGraph.graphPropertyModel
										.getListHandlerName());
						setReferenceValues(fold, loggingData, new Timestamp(
								keyTime));
						fillGraph.repaint();
					}
				}
			}

			private long getReferenceValue(int clickIndex) {
				Calendar cal = Calendar.getInstance();
				cal.set(Calendar.MILLISECOND, 0);
				cal.set(Calendar.SECOND, 0);
				cal.set(Calendar.MINUTE, 0);
				cal.set(Calendar.HOUR_OF_DAY, 0);
				cal.set(Calendar.DATE, 1);
				cal.set(Calendar.MONTH, clickIndex);
				cal.add(Calendar.YEAR, -1);
				return cal.getTimeInMillis();
			}

			private void setReferenceValues(
					int fold,
					LoggingData loggingData,
					Timestamp timestamp) {

				if (loggingData != null)
					loggingData.first();
				for (int series = 0; series < fillGraph.graphPropertyModel
						.getSeriesSize(); series++) {

					double value = 0.0;
					if (loggingData != null)
						value = loggingData.next();

					fillGraph.graphPropertyModel.setReferenceValue(
							series,
							fold,
							value);
					fillGraph.graphPropertyModel.setReferenceTime(
							series,
							fold,
							timestamp);
				}
			}
		}
	}

	/**
	 * OtfvpeBoEYXN[o[łB
	 */
	private static class BarGraphScrollBar extends JScrollBar implements
			PropertyChangeListener {
		private static final long serialVersionUID = 170492832047340277L;
		/** OtR|[lg̎Q */
		private FillGraph fillGraph;

		/**
		 * RXgN^
		 * 
		 * @param fillGraph OtR|[lg̎Q
		 */
		BarGraphScrollBar(FillGraph fillGraph) {
			super(JScrollBar.HORIZONTAL);
			this.fillGraph = fillGraph;

			fillGraph.graphPropertyModel.addPropertyChangeListener(this);
			init();
		}

		/**
		 * 
		 */
		private void init() {
			long startTime = fillGraph.getStartTime();
			long endTime = fillGraph.getEndTime();
			long scaleOneTime = fillGraph.graphPropertyModel
					.getHorizontalScaleWidth();
			int extentSize = fillGraph.graphPropertyModel
					.getHorizontalScaleCount()
					* (fillGraph.graphPropertyModel.getFoldCount() + 1) - 1;

			int maxIndexCount = Math
					.round((endTime - startTime) / scaleOneTime);
			// X^[gʒuw
			fillGraph.currentStartIndex = maxIndexCount - extentSize;

			setPropertys(extentSize, 0, maxIndexCount);
		}

		/**
		 * XN[o[̃vpeBݒ肵܂B
		 */
		private void setPropertys(int extent, int min, int max) {
			// XN[͈͂ƌ݈ʒuݒ
			this.setValues(fillGraph.currentStartIndex, extent, min, max);
			// ̖ڐ\
			fillGraph.changeDisplayData();
			// XN[͈͂΁AXN[o[\Ȃ
			BoundedRangeModel boundedRengeModel = this.getModel();
			if (boundedRengeModel.getMaximum() - boundedRengeModel.getMinimum() <= boundedRengeModel
					.getExtent()) {
				setVisible(false);
			} else {
				setVisible(true);
			}
		}

		/**
		 * Otf[^f̃oEYvpeBCxg܂B
		 * 
		 * @param evt PropertyChangeEvent
		 */
		public void propertyChange(PropertyChangeEvent evt) {
			long startTime = fillGraph.getStartTime();
			long endTime = fillGraph.getEndTime();
			long scaleOneTime = fillGraph.graphPropertyModel
					.getHorizontalScaleWidth();
			int extentSize = fillGraph.graphPropertyModel
					.getHorizontalScaleCount()
					* (fillGraph.graphPropertyModel.getFoldCount() + 1) - 1;

			int maxIndexCount = Math
					.round((endTime - startTime) / scaleOneTime);
			double coefficient = (double) maxIndexCount / (double) getMaximum();
			double index = (double) fillGraph.currentStartIndex * coefficient;

			int diff = maxIndexCount - extentSize;
			if (diff < index) {
				index = diff;
			}
			fillGraph.currentStartIndex = (int) Math.max(Math.round(index), 0);

			setPropertys(extentSize, 0, maxIndexCount);
		}
	}

}
