/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/applet/graph/demand/DemandGraphModel.java,v 1.9.2.3 2005/03/11 06:50:47 frdm Exp $
 * $Revision: 1.9.2.3 $
 * $Date: 2005/03/11 06:50:47 $
 *
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.applet.graph.demand;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataReferencer;
import jp.gr.javacons.jim.DataReferencerOwner;
import jp.gr.javacons.jim.DataValueChangeEvent;
import jp.gr.javacons.jim.DataValueChangeListener;

import org.F11.scada.applet.graph.AbstractGraphModel;
import org.F11.scada.applet.graph.LoggingData;
import org.F11.scada.data.ConvertValue;
import org.F11.scada.data.WifeData;
import org.F11.scada.data.WifeDataAnalog;
import org.F11.scada.server.demand.DemandDataReferencer;
import org.F11.scada.xwife.server.WifeDataProvider;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.collections.primitives.DoubleList;

/**
 * f}hOtp̃f[^z_AOtf𐶐܂B
 * _d @- (0, 0, Ot̉E[, _d͒l)
 * ڕWd @- (0, 0, Ot̉E[, ڕWd͒l)
 * ex@ @- (xl, Otől, xl, Otől)
 * \zd́@ - (JE^l, ݒl, Ot̉E[, \zd͒l)
 * ߋd͒l - JE^l̃p^ graphdata(LinkedHashMap) A
 * @@@@@   JE^l̒l𒊏oOtff[^𐶐B
 *
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class DemandGraphModel
		extends AbstractGraphModel
		implements DataReferencerOwner, DataValueChangeListener {

	/** DataHolder^CvłB */
	private static final Class[][] WIFE_TYPE_INFO =
		{ { DataHolder.class, WifeData.class }
	};
	/** QƂ郊t@TłB */
	private DataReferencer[] dataReferencers;
	private LoggingData[] demandDatas;
	private volatile int rowIndex;

	//------------------------------------------------------//
	// f}hOtŗL̃vpeB
	//------------------------------------------------------//
	/** _d */
	private double contractElectricity;
	/** ڕWd */
	private double targetElectricity;
	/** \zd */
	private double forecastElectricity;
	/** x񔭐 x W */
	private double[] alarmTimes;
	/** JE^l */
	private int counter;
	/** x WJE^̃f[^l */
	private double currentElectricity;
	/** f}hO̊Ԋu */
	private int logint;

	/**
	 * f}hOtf𐶐܂B
	 */
	public DemandGraphModel(DataReferencer[] dataReferencers) {
		super();
		this.dataReferencers = dataReferencers;
		init();
	}

	private void init() {
		for (int i = 0; i < dataReferencers.length; i++) {
			dataReferencers[i].connect(this);
		}
		changeData();
	}

	public boolean next(String name) {
		synchronized (this) {
			return demandDatas.length > rowIndex;
		}
	}

	public Object get(String name) {
		synchronized (this) {
			return demandDatas[rowIndex++];
		}
	}

	/**
	 * ŏR[h̃^CX^vԂ܂B
	 * @return ŏR[h̃^CX^v
	 */
	public Object firstKey(String name) {
		synchronized (this) {
			return demandDatas[0].getTimestamp();
		}
	}

	/**
	 * ŏIR[h̃^CX^vԂ܂B
	 * @return ŏIR[h̃^CX^v
	 */
	public Object lastKey(String name) {
		synchronized (this) {
			return demandDatas[demandDatas.length - 1].getTimestamp();
		}
	}

	/**
	 * ^CX^v key ȑÕR[hA|C^ʒuÂ܂B
	 * ̃\bhňʒuÂꂽ|C^́A key ȑÕR[hP܂݂܂B
	 * AAkey 擪R[hȑÕR[hꍇ́A擪R[hɂȂ܂B
	 * @param key 郌R[h̃^CX^v
	 */
	public void findRecord(String name, Timestamp key) {
		rowIndex = 0;
	}

	/**
	 * DataHolder^CvԂ܂B
	 */
	public Class[][] getReferableDataHolderTypeInfo(DataReferencer dr) {
		return WIFE_TYPE_INFO;
	}

	/**
	 * f[^ύXCxg
	 */
	public void dataValueChanged(DataValueChangeEvent evt) {
		changeData();
		firePropertyChange(null, null);
	}

	private void changeData() {
//		logger.debug("");
		contractElectricity = doConvert(dataReferencers[0]);
		targetElectricity = doConvert(dataReferencers[1]);

		alarmTimes = new double[2];
		alarmTimes[0] = doConvert(dataReferencers[2]);
		alarmTimes[1] = doConvert(dataReferencers[3]);

		currentElectricity = doConvert(dataReferencers[4]);
		forecastElectricity = doConvert(dataReferencers[5]);
		counter = (int) getValue(dataReferencers[6]);

		DataHolder dh = dataReferencers[6].getDataHolder();
		if (dh == null) {
			logger.debug("counter data id null");
			return;
		}
		Map map = (Map) dh.getParameter(DemandDataReferencer.GRAPH_DATA);
		if (map == null) {
			logger.debug("demand graph data id null");
			return;
		}
		synchronized (this) {
			demandDatas = new LoggingData[counter + 1];
			for (int i = 0; i < counter; i++) {
				DoubleList list = new ArrayDoubleList();
				Object obj = map.get(new Integer(i));
				if (obj == null) {
					list.add(0);
				} else {
				    Double d = (Double)obj;
					list.add(d.doubleValue());
				}
				demandDatas[i] = new LoggingData(convertTimestamp(i), list);
			}
			DoubleList list = new ArrayDoubleList();
			list.add(currentElectricity);
			demandDatas[counter] = new LoggingData(convertTimestamp(counter), list);
		}
	}

	private double getValue(DataReferencer dr) {
		DataHolder dh = dr.getDataHolder();
		if (dh == null) {
			logger.debug("DataHolder Not found");
			return 0;
		} else {
			WifeDataAnalog wa = (WifeDataAnalog) dh.getValue();
			return wa.doubleValue();
		}
	}

	private double doConvert(DataReferencer dr) {
		DataHolder dh = dr.getDataHolder();
		if (dh == null) {
			logger.debug("DataHolder Not found");
			return 0;
		} else {
			WifeDataAnalog wa = (WifeDataAnalog) dh.getValue();
			ConvertValue convertValue =
				(ConvertValue) dh.getParameter(WifeDataProvider.PARA_NAME_CONVERT);

			return convertValue.convertDoubleValue(wa.doubleValue());
		}
	}

	// JE^^CX^vɕϊ
	private Timestamp convertTimestamp(int count) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.MILLISECOND, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MINUTE, 0);

		for (int i = 0; i < count; i++) {
			cal.add(Calendar.SECOND, logint);
		}

		return new Timestamp(cal.getTimeInMillis());
	}

	public double getContractElectricity() {
		return contractElectricity;
	}

	public double getTargetElectricity() {
		return targetElectricity;
	}

	public double getForecastElectricity() {
		return forecastElectricity;
	}

	public double[] getAlarmTimes() {
		return alarmTimes;
	}

	public int getCounter() {
		return counter;
	}

	public double getCurrentElectricity() {
		return currentElectricity;
	}

	public void disConnect() {
		for (int i = 0; i < dataReferencers.length; i++) {
			dataReferencers[i].disconnect(this);
		}
	}

    public void start() {
    }

    public void stop() {
    }

	public void setLogint(int logint) {
		this.logint = logint;
		changeData();
	}
}
