package org.F11.scada.applet.schedule;

/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.beans.PropertyChangeListener;

import org.F11.scada.applet.symbol.Editable;
import org.F11.scada.data.WifeDataSchedule;

/**
 * XPW[f[^fC^[tFCXłB
 */
public interface ScheduleModel extends Editable {
	/**
	 * [gIuWFNgɒlݒ肵܂B
	 */
	public void setValue();

	/**
	 * f[^ҏWꂽꍇ true Ԃ܂B
	 */
	public boolean isEditing();

	/**
	 * ێĂXPW[f[^XV܂B
	 */
	public void writeData();

	/**
	 * ێĂXPW[f[^AhD܂B
	 */
	public void undoData();

	/**
	 * XPW[f[^̃O[vw肵CfbNXɕύX܂B
	 * 
	 * @param index O[vCfbNX
	 */
	public void setGroupNo(int index);

	/**
	 * O[vNo Ԃ܂
	 */
	public int getGroupNo();

	/**
	 * O[vNo ̍ő吔Ԃ܂
	 */
	public int getGroupNoMax();

	/**
	 * XPW[p^[̃CfbNXԂ܂B
	 * 
	 * @param index
	 */
	public int getDayIndex(int index);

	/**
	 * XPW[p^[̃CfbNXԂ܂B
	 * 
	 * @param index
	 */
	public String getDayIndexName(int index);

	/**
	 * ̃CfbNXԂ܂B
	 * 
	 * @param index
	 */
	public int getSpecialDayOfIndex(int index);

	/**
	 * ڃp^[̃TCYԂ܂B
	 * 
	 * @return ڃp^[̃TCY
	 */
	public int getPatternSize();

	/**
	 * XPW[ On/Off ̍ő񐔂Ԃ܂B
	 * 
	 * @return XPW[ On/Off ̍ő
	 */
	public int getNumberSize();

	/**
	 * XPW[sfԂ܂B
	 * 
	 * @param index Ԃs
	 * @return XPW[sfԂ܂B
	 */
	public ScheduleRowModel getScheduleRowModel(int index);

	/**
	 * f[^fύX邽тɒʒm郊XgɃXi[ǉ܂B
	 * 
	 * @param listener PropertyChangeListener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener);

	/**
	 * f[^fύX邽тɒʒm郊Xg烊Xi[폜܂B
	 * 
	 * @param listener PropertyChangeListener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener);

	/**
	 * vpeBύXXi[폜܂B
	 */
	void removePropertyChangeListeners();

	/**
	 * O[vǉ܂B
	 * 
	 * @param dataProvider
	 * @param dataHolder
	 * @param flagHolder
	 */
	public void addGroup(String dataProvider, String dataHolder, String flagHolder);

	/**
	 * O[v̂Ԃ܂
	 * 
	 * @return O[v̂Ԃ܂
	 */
	public String getGroupName();

	/**
	 * f[^t@T[ؒf܂B
	 */
	public void disConnect();

	/**
	 * Jg̃XPW[f[^Ώۂ̃O[vɕ܂B
	 * 
	 * @param dest ̃XPW[O[v
	 */
	void duplicateGroup(int[] dest);

	/**
	 * Jg̃XPW[f[^̗jf[^Ώۂ̗jɕ܂B
	 * 
	 * @param src jԍ
	 * @param dest jԍ
	 */
	void duplicateWeekOfDay(int src, int[] dest);

	/**
	 * O[vGg̔zԂ܂B
	 * 
	 * @return O[vGg̔z
	 */
	GroupElement[] getGroupNames();

	/**
	 * XPW[ʂŏɂ̌(Ȃ2, 7Ȃ7Ȃ)Ԃ܂B
	 * 
	 * @return XPW[ʂŏɂ̌(Ȃ2, 7Ȃ7Ȃ)Ԃ܂B
	 */
	int getTopSize();

	/**
	 * f̒̃XPW[lԂ܂B
	 * 
	 * @return f̒̃XPW[lԂ܂B
	 */
	WifeDataSchedule getDataSchedule();

	/**
	 * fɃXPW[lݒ肵܂B
	 * 
	 * @param schedule fɃXPW[lݒ肵܂B
	 */
	void setDataSchedule(WifeDataSchedule schedule);

	/**
	 * f[^ύXCxg𔭉΂܂B
	 * @param oldValue ύXÕIuWFNg
	 * @param newValue ύX̃IuWFNg
	 */
	void firePropertyChange(Object oldValue, Object newValue);
}
