/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/data/HolderData.java,v 1.7 2003/10/31 04:38:50 frdm Exp $
 * $Revision: 1.7 $
 * $Date: 2003/10/31 04:38:50 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
package org.F11.scada.data;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * f[^z_̒l𐶐ׂ̏ێNXłB
 * RMIŃVACYDataHolderŒʐM̂͏dׂ̃NXoRŒʐM܂B
 * ̃NX͕sσNXłB
 * 
 * <p><b>ӁF̃NXhashCode()\bhAequals(Object o)\bh́AӐ}IɓtB[h
 * valuelĂ܂B</b>
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public final class HolderData implements Serializable {
	private static final long serialVersionUID = 2668107215141257936L;
	/** f[^z_[ */
	private final String holder;
	/** f[^l̃oCg\ */
	private final byte[] value;
	/** ŏIXV */
	private final long time;
	/** f}hOtf[^ */
	private final Map demandData;
	
	/**
	 * RXgN^
	 * @param holder f[^z_[
	 * @param value f[^lbytez
	 * @param time ŏIXV
	 * @param f}hOtf[^
	 */
	public HolderData(String holder, byte[] value, long time, Map demandData) {
		if (holder == null) {
			throw new IllegalArgumentException("holder need not null.");
		}
		if (value == null) {
			throw new IllegalArgumentException("value need not null.");
		}
		this.holder = holder;
		this.value = new byte[value.length];
		System.arraycopy(value, 0, this.value, 0, value.length);
		this.time = time;
		if (demandData != null) {
			this.demandData = new LinkedHashMap(demandData);
		} else {
			this.demandData = null;
		}
	}

	/**
	 * f[^z_[Ԃ܂B
	 * @return f[^z_[
	 */
	public String getHolder() {
		return holder;
	}

	/**
	 * f[^lbytezԂ܂B
	 * @return f[^lbytez
	 */
	public byte[] getValue() {
		byte[] b = new byte[value.length];
		System.arraycopy(value, 0, b, 0, value.length);
		return b;
	}

	/**
	 * f[^̍XVԂ܂B
	 * @return long XV
	 */
	public long getTime() {
		return time;
	}
	
	/**
	 * f}hOtf[^Ԃ܂B
	 * @return f}hOtf[^Ԃ܂B
	 */
	public Map getDemandData() {
		return demandData != null
			? Collections.unmodifiableMap(demandData)
			: null;
	}

	/**
	 * ̃IuWFNgƎw肳ꂽIuWFNgr܂B
	 * ̃\bh͈Ӑ}IɃz_݂̂r悤Ă܂B
	 * @param obj rΏۂ̃IuWFNg
	 * @return z_lȂ true قȂȂ false Ԃ܂
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof HolderData)) {
			return false;
		}
		HolderData hd = (HolderData)obj;
		return hd.holder.equals(holder);
	}

	/**
	 * ̃IuWFNg̃nbVR[hԂ܂B
	 * ̃\bh͈Ӑ}IɃz_݂̂AnbVԂ悤Ă܂B
	 * 
	 * @return z_̃nbVԂ܂
	 */
	public int hashCode() {
		return holder.hashCode();
	}

	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	/**
	 * hIreadResolve\bhB
	 * sɃfVACŶh~܂B
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new HolderData(holder, value, time, demandData);
	}

}
