/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/data/WifeDataSchedule.java,v 1.4.2.6 2007/03/19 01:12:19 frdm Exp $
 * $Revision: 1.4.2.6 $
 * $Date: 2007/03/19 01:12:19 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;

import org.F11.scada.Globals;

/**
 * ͈͂̃GAw肵ONOFF񐔂ƓŁAǗXPW[f[^NXłB XPW[f[^擾Eݒ肷̂Ɏgp܂B
 * ̃NX͕sσNXłB
 */
public final class WifeDataSchedule implements WifeData, Serializable {
	private static final long serialVersionUID = 9131723169279672709L;
	/** XPW[ڃp^[ł */
	private final SchedulePattern pattern;
	/** On/Off ̃^Ce[uł */
	private final OnOffTime[][] timeTable;
	/** ̃CX^X̃nbVR[hł */
	private transient volatile int hashCode;
	/** ̃CX^X̃[hTCYł */
	private transient volatile int wordSize;
	/** O[v */
	private final String groupName;

	/**
	 * vCx[gERXgN^
	 * 
	 * @param pattern XPW[p^[
	 * @param number On/Off XPW[̉
	 * @param groupName O[v
	 */
	private WifeDataSchedule(
			SchedulePattern pattern,
			int number,
			String groupName) {
		this.pattern = pattern;
		timeTable = new OnOffTime[this.pattern.size()][number];
		for (int i = timeTable.length - 1; i >= 0; i--) {
			Arrays.fill(timeTable[i], new OnOffTime(0, 0));
		}
		if (groupName != null) {
			this.groupName = groupName;
		} else {
			this.groupName = Globals.NULL_STRING;
		}
	}

	/**
	 * vCx[gRXgN^
	 * 
	 * @param pattern XPW[p^[
	 * @param timeTable On/Off ̃^Ce[u̔z
	 * @param groupName O[v
	 */
	private WifeDataSchedule(
			SchedulePattern pattern,
			OnOffTime[][] timeTable,
			String groupName) {
		this.pattern = pattern;
		this.timeTable = new OnOffTime[timeTable.length][timeTable[0].length];
		for (int i = 0; i < timeTable.length; i++) {
			for (int j = 0; j < timeTable[i].length; j++) {
				this.timeTable[i][j] = timeTable[i][j];
			}
		}
		if (groupName != null) {
			this.groupName = groupName;
		} else {
			this.groupName = Globals.NULL_STRING;
		}
	}

	/**
	 * ̃IuWFNg̕\Ԃ܂B
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(this.getClass().getName());
		buffer.append("[patten=" + pattern.toString() + ",\ntimeTable:\n");
		for (int i = 0; i < timeTable.length; i++) {
			for (int j = 0; j < timeTable[i].length; j++) {
				buffer.append(timeTable[i][j].toString() + " ");
			}
			buffer.append("\n");
		}
		buffer.append(", groupName=").append(groupName);
		buffer.append("]");
		return buffer.toString();
	}

	/**
	 * ̃IuWFNgƑ̃IuWFNgǂ܂B
	 */
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (!(obj instanceof WifeDataSchedule)) {
			return false;
		}
		WifeDataSchedule sc = (WifeDataSchedule) obj;

		if (!this.pattern.equals(sc.pattern))
			return false;

		for (int i = 0; i < timeTable.length; i++) {
			if (!Arrays.equals(this.timeTable[i], sc.timeTable[i]))
				return false;
		}

		if (!this.groupName.equals(sc.groupName)) {
			return false;
		}

		return true;
	}

	/**
	 * ̃IuWFNg̃nbVR[hԂ܂B
	 */
	public int hashCode() {
		if (hashCode == 0) {
			int result = 17;
			result = 37 * result + pattern.hashCode();
			for (int i = 0; i < timeTable.length; i++) {
				for (int j = 0; j < timeTable[i].length; j++) {
					result = 37 * result + timeTable[i][j].hashCode();
				}
			}
			result = 37 * result + groupName.hashCode();
			hashCode = result;
		}
		return hashCode;
	}

	/**
	 * oCgzf[^ɕϊ܂B
	 * 
	 * @param b oCgz
	 */
	public WifeData valueOf(byte[] b) {
		int byteSize = getWordSize() * 2;
		if (byteSize != b.length)
			throw new IllegalArgumentException("DataSize : " + byteSize
					+ "  Argument : " + b.length);

		OnOffTime[][] timeTable = new OnOffTime[this.timeTable.length][this.timeTable[0].length];

		ByteArrayInputStream is = new ByteArrayInputStream(b);
		for (int i = 0; i < timeTable.length; i++) {
			for (int j = 0; j < timeTable[i].length; j++) {
				byte[] onOffByte = new byte[this.timeTable[i][j].getWordSize() * 2];
				is.read(onOffByte, 0, this.timeTable[i][j].getWordSize() * 2);
				timeTable[i][j] = this.timeTable[i][j].valueOf(onOffByte);
			}
		}
		return new WifeDataSchedule(this.pattern, timeTable, this.groupName);
	}

	/**
	 * ̃f[^̒loCgzϊĕԂ܂B
	 * 
	 * @return oCgz
	 */
	public byte[] toByteArray() {
		ByteArrayOutputStream os = new ByteArrayOutputStream(getWordSize() * 2);

		for (int i = 0; i < timeTable.length; i++) {
			for (int j = 0; j < timeTable[i].length; j++) {
				try {
					os.write(timeTable[i][j].toByteArray());
				} catch (IOException ex) {
					ex.printStackTrace();
				}
			}
		}
		return os.toByteArray();
	}

	/**
	 * ̃f[^̃[hԂ܂B
	 * 
	 * @return ̃f[^̃[h
	 */
	public int getWordSize() {
		if (wordSize == 0) {
			int size = 0;
			for (int i = timeTable.length - 1; i >= 0; i--) {
				for (int j = timeTable[i].length - 1; j >= 0; j--) {
					size += timeTable[i][j].getWordSize();
				}
			}
			wordSize = size;
		}
		return wordSize;
	}

	/**
	 * WifeDataSchedule NX̃t@Ng\bhłB A&A W̍ڃp^[gpAꂽIuWFNgԂ܂B
	 * 
	 * @param special ̐
	 * @param number On/Off XPW[̉
	 * @return WifeDataSchedule ̃CX^X
	 * @deprecated {@link #valueOf(int, int, String)}gpĉB
	 */
	public static WifeDataSchedule valueOf(int special, int number) {
		return valueOf(special, number, null);
	}

	/**
	 * WifeDataSchedule NX̃t@Ng\bhłB A&A W̍ڃp^[gpAꂽIuWFNgԂ܂B
	 * 
	 * @param special ̐
	 * @param number On/Off XPW[̉
	 * @param groupName O[v
	 * @return WifeDataSchedule ̃CX^X
	 */
	public static WifeDataSchedule valueOf(
			int special,
			int number,
			String groupName) {
		return valueOf(new DefaultSchedulePattern(special), number, groupName);
	}

	/**
	 * WifeDataSchedule NX̃t@Ng\bhłB Ŏw肵ڃp^[gpāAꂽIuWFNgԂ܂B
	 * 
	 * @param pattern ڃp^[
	 * @param number On/Off XPW[̉
	 * @return WifeDataSchedule ̃CX^X
	 */
	public static WifeDataSchedule valueOf(SchedulePattern pattern, int number) {
		return valueOf(pattern, number, null);
	}

	/**
	 * WifeDataSchedule NX̃t@Ng\bhłB Ŏw肵ڃp^[gpāAꂽIuWFNgԂ܂B
	 * 
	 * @param pattern ڃp^[
	 * @param number On/Off XPW[̉
	 * @param groupName O[v
	 * @return WifeDataSchedule ̃CX^X
	 */
	public static WifeDataSchedule valueOf(
			SchedulePattern pattern,
			int number,
			String groupName) {
		return new WifeDataSchedule(pattern, number, groupName);
	}

	/**
	 * O[vȊO𕡐XPW[IuWFNgԂ܂B
	 * 
	 * @param src O[v܂񂾃XPW[IuWFNg
	 * @return O[vȊO𕡐XPW[IuWFNgԂ܂
	 */
	public WifeDataSchedule duplicate(WifeDataSchedule src) {
		return new WifeDataSchedule(pattern, timeTable, src.groupName);
	}

	/**
	 * Ŏw肳ꂽXPW[f[^Ԃ܂B
	 */
	public int getOnTime(int weekOfDay, int number) {
		numberCheck(number);
		return timeTable[weekOfDay][number].getOnTime();
	}

	/**
	 * Ŏw肳ꂽXPW[f[^Ԃ܂B
	 */
	public int getOffTime(int weekOfDay, int number) {
		numberCheck(number);
		return timeTable[weekOfDay][number].getOffTime();
	}

	/**
	 * Ŏw肳ꂽXPW[f[^ݒ肵 <code>WifeDataSchedule</code> Ԃ܂B
	 */
	public WifeDataSchedule setOnTime(int weekOfDay, int number, int time) {
		numberCheck(number);

		timeTable[weekOfDay][number] = timeTable[weekOfDay][number]
				.setOnTime(time);
		return new WifeDataSchedule(
				this.pattern,
				this.timeTable,
				this.groupName);
	}

	/**
	 * Ŏw肳ꂽXPW[f[^ݒ肵 <code>WifeDataSchedule</code> Ԃ܂B
	 */
	public WifeDataSchedule setOffTime(int weekOfDay, int number, int time) {
		numberCheck(number);

		timeTable[weekOfDay][number] = timeTable[weekOfDay][number]
				.setOffTime(time);
		return new WifeDataSchedule(
				this.pattern,
				this.timeTable,
				this.groupName);
	}

	/**
	 * Ŏw肳ꂽO[vݒ肵 <code>WifeDataSchedule</code> Ԃ܂B
	 * 
	 * @param groupName O[v
	 * @version 2.0.21
	 */
	public WifeDataSchedule setGroupName(String groupName) {
		return new WifeDataSchedule(this.pattern, this.timeTable, groupName);
	}

	/**
	 * `FbN܂B
	 */
	private void numberCheck(int number) {
		if (number < 0 || number >= timeTable[0].length) {
			StringBuffer buffer = new StringBuffer();
			buffer.append("number = ").append(number);
			buffer.append(" [numberMax = ").append(timeTable[0].length).append(
					"]");
			throw new IllegalArgumentException(buffer.toString());
		}
	}

	/**
	 * XPW[ڂ̑Ԃ܂B
	 */
	public int getPatternSize() {
		return pattern.size();
	}

	/**
	 * XPW[f[^񐔂̑Ԃ܂B
	 */
	public int getNumberSize() {
		return timeTable[0].length;
	}

	/**
	 * Ŏw肳ꂽ̃CfbNXԂ܂B
	 * 
	 * @param ̎ޔԍ
	 */
	public int getSpecialDayOfIndex(int n) {
		return pattern.getSpecialDayOfIndex(n);
	}

	/**
	 * ̍(j)ɂCfbNXԂ܂B
	 * 
	 * @param n ڂ̎
	 * @return ̍ڂɂCfbNX
	 */
	public String getDayIndexName(int n) {
		return pattern.getDayIndexName(n);
	}

	/**
	 * ̍(j)ɂCfbNXԂ܂B
	 * 
	 * @param n ڂ̎(j)
	 * @return ̍ڂɂCfbNX
	 */
	public int getDayIndex(int n) {
		return pattern.getDayIndex(n);
	}

	/**
	 * O[v̂܂B
	 * 
	 * @return O[v̂܂
	 */
	public String getGroupName() {
		return groupName;
	}

	/**
	 * ̃IuWFNg̃CfbNX0̃f[^̃IuWFNgɃRs[Ԃ܂B
	 * 
	 * @param dest Rs[IuWFNg
	 * @return ̃IuWFNg̃CfbNX0̃f[^̃IuWFNgɃRs[Ԃ܂B
	 */
	public WifeDataSchedule duplicateTodayAndTomorrow(WifeDataSchedule dest) {
		WifeDataSchedule on = duplicate(this);
		for (int i = 0; i < getPatternSize(); i++) {
			for (int j = 0; j < getNumberSize(); j++) {
				on = on.setOnTime(i, j, dest.getOnTime(i, j));
				on = on.setOffTime(i, j, dest.getOffTime(i, j));
			}
		}
		return on;
	}


	/**
	 * XPW[ʂŏɂ̌(Ȃ2, 7Ȃ7Ȃ)Ԃ܂B
	 * @return XPW[ʂŏɂ̌(Ȃ2, 7Ȃ7Ȃ)Ԃ܂B
	 */
	public int getTopSize() {
		return pattern.getTopSize();
	}

	/**
	 * hIreadResolve\bhB sɃfVACŶh~܂B
	 * 
	 * @return Object fVACYꂽCX^X
	 * @throws ObjectStreamException fVACYɎs
	 */
	private Object readResolve() throws ObjectStreamException {
		return new WifeDataSchedule(pattern, timeTable, groupName);
	}
}
