/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/parser/alarm/AlarmTableConfig.java,v 1.3.2.2 2005/07/05 10:26:39 hori Exp $
 * $Revision: 1.3.2.2 $
 * $Date: 2005/07/05 10:26:39 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.parser.alarm;

import java.awt.Color;

import org.F11.scada.applet.symbol.ColorFactory;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * xEԈꗗ̐ݒNXł
 * 
 * @author Hideaki Maekawa <frdm@users.sourceforge.jp>
 */
public class AlarmTableConfig {
	/** ftHg̃e[uwiF */
	private static final Color DEFAULT_BACKGROUND = ColorFactory.getColor("white");
	/** ftHg̃wb_[wiF */
	private static final Color DEFAULT_HEADERBACKGROUND = ColorFactory.getColor("lightgrey");
	/** ftHg̃wb_[F */
	private static final Color DEFAULT_HEADERFOREGROUND = ColorFactory.getColor("black");
	/** tHgݒ */
	private FontConfig fontConfig;
	/** e[uwiF */
	private String backGround;
	/** wb_[wiF */
	private String headerBackGround;
	/** wb_[F */
	private String headerForeGround;
	/** ftHg\̃^uԍ (0`2) */
	private int defaultTabNo;
	/** s` */
	private LineCountConfig lineCountConfig = new LineCountConfig(20, 0);

	/**
	 * tHgݒԂ܂
	 * 
	 * @return tHgݒ
	 */
	public FontConfig getFontConfig() {
		return fontConfig;
	}

	/**
	 * tHgݒݒ肵܂
	 * 
	 * @param config
	 *            tHgݒ
	 */
	public void setFontConfig(FontConfig config) {
		fontConfig = config;
	}

	/**
	 * e[uwiFԂ܂B
	 * 
	 * @return e[uwiFԂ܂
	 */
	public String getBackGround() {
		return backGround;
	}

	/**
	 * e[uwiFݒ肵܂B
	 * 
	 * @param color
	 *            e[uwiF
	 */
	public void setBackGround(String color) {
		this.backGround = color;
	}

	/**
	 * wb_[wiFԂ܂B
	 * 
	 * @return wb_[wiFԂ܂
	 */
	public String getHeaderBackGround() {
		return headerBackGround;
	}

	/**
	 * wb_[wiFݒ肵܂B
	 * 
	 * @param color
	 *            wb_[wiF
	 */
	public void setHeaderBackGround(String color) {
		this.headerBackGround = color;
	}

	/**
	 * wb_[FԂ܂B
	 * 
	 * @return wb_[FԂ܂
	 */
	public String getHeaderForeGround() {
		return headerForeGround;
	}

	/**
	 * wb_[Fݒ肵܂B
	 * 
	 * @param color
	 *            wb_[F
	 */
	public void setHeaderForeGround(String color) {
		this.headerForeGround = color;
	}

	/**
	 * e[uwiF Color IuWFNgԂ܂B
	 * 
	 * @return e[uwiF Color IuWFNgԂ܂B
	 */
	public Color getBackGroundColor() {
		return ColorFactory.getColor(backGround) == null ? DEFAULT_BACKGROUND : ColorFactory
				.getColor(backGround);
	}

	/**
	 * wb_[wiF Color IuWFNgԂ܂B
	 * 
	 * @return wb_[wiF Color IuWFNgԂ܂B
	 */
	public Color getHeaderBackGroundColor() {
		return ColorFactory.getColor(headerBackGround) == null
				? DEFAULT_HEADERBACKGROUND
				: ColorFactory.getColor(headerBackGround);
	}

	/**
	 * wb_[F Color IuWFNgԂ܂B
	 * 
	 * @return wb_[F Color IuWFNgԂ܂B
	 */
	public Color getHeaderForeGroundColor() {
		return ColorFactory.getColor(headerForeGround) == null
				? DEFAULT_HEADERFOREGROUND
				: ColorFactory.getColor(headerForeGround);
	}

	/**
	 * s`Ԃ܂B
	 * 
	 * @return
	 */
	public LineCountConfig getLineCountConfig() {
		return lineCountConfig;
	}

	/**
	 * s`ݒ肵܂B
	 * 
	 * @param lineCountConfig
	 */
	public void setLineCountConfig(LineCountConfig lineCountConfig) {
		this.lineCountConfig = lineCountConfig;
	}

	/**
	 * ̃IuWFNg̕\Ԃ܂
	 */
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	/**
	 * ftHg\̃^uԍԂ܂
	 * 
	 * @return ftHg\̃^uԍ
	 */
	public int getDefaultTabNo() {
		return defaultTabNo;
	}

	/**
	 * ftHg\̃^uԍݒ肵܂B 0 <= i <= 2 Őݒ肷Kv܂B͈̔͊O̐lnꂽꍇ́A0 ݒ肵܂B
	 * 
	 * @param i
	 *            \^uԍ (0`2)
	 */
	public void setDefaultTabNo(int i) {
		defaultTabNo = i;
	}

}
