package org.F11.scada.scheduling;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.Logger;

/**
 * T(j) 莞ԂXPW[ECe[^[NXł
 */
public class WeeklyIterator implements ScheduleIterator {
	/** ̓vZJ_[ */
	private final Calendar calendar = Calendar.getInstance();
	/** Logging API */
	private static Logger log = Logger.getLogger(WeeklyIterator.class);

	/**
	 * EEbw肵āACe[^[܂B
	 *
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 */
	public WeeklyIterator(int hourOfDay, int minute, int second) {
		this(hourOfDay, minute, second, new Date());
	}

	/**
	 * tEEEbw肵āACe[^[܂B
	 * tIuWFNg̎EEb͈̎EEbŏ㏑܂
	 *
	 * @param hourOfDay 
	 * @param minute 
	 * @param second b
	 * @param date t
	 */
	public WeeklyIterator(int hourOfDay, int minute, int second, Date date) {
		calendar.setTime(date);
		while (Calendar.MONDAY != calendar.get(Calendar.DAY_OF_WEEK)) {
			calendar.add(Calendar.DATE, 1);
		}
		calendar.set(Calendar.HOUR_OF_DAY, hourOfDay);
		calendar.set(Calendar.MINUTE, minute);
		calendar.set(Calendar.SECOND, second);
		calendar.set(Calendar.MILLISECOND, 0);
		// TZo
		if (!calendar.getTime().before(date)) {
			calendar.add(Calendar.DATE, -7);
		}
	}

	/**
	 * ɎsԂ܂B
	 * @return ɎsԂ܂B
	 */
	public Date next() {
		calendar.add(Calendar.DATE, 7);
		if (log.isInfoEnabled()) {
			DateFormat fmt = DateFormat.getDateTimeInstance();
			log.info("Next schedule date : " + fmt.format(calendar.getTime()));
		}
		return calendar.getTime();
	}
}
