/*
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.F11.scada.server.edit;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.F11.scada.WifeUtilities;
import org.F11.scada.server.autoprint.AutoPrintEditor;

/**
 * ҏW@\IuWFNgɁAύXCxg𔭐NXł
 * @author hori
 */
public class ServerEditManager extends UnicastRemoteObject
		implements ServerEditHandler {

	private static final long serialVersionUID = 944970692114214286L;
	/** GfB^[IuWFNg */
	private AutoPrintEditor editor;

	/**
	 * ̕ύXCxgǗ}l[W[܂
	 * @param port RMIgp|[g
	 * @param editor GfB^[IuWFNg
	 * @throws RemoteException [gG[
	 * @throws MalformedURLException [gG[
	 */
	public ServerEditManager(int port, AutoPrintEditor editor)
			throws RemoteException, MalformedURLException {

		super(port);
		Naming.rebind(WifeUtilities.createRmiServerEditManager(), this);
		this.editor = editor;
	}

	/**
	 * 󎚐ݒp[^̕ύXT[o[ɒʒm܂
	 * @exception RemoteException [gG[
	 */
	public void editAutoPrint() throws RemoteException {
		editor.reloadAutoPrint();
	}

	/**
	 * ̃T[o[̂Ԃ܂B
	 * @return ̃T[o[
	 */
	public String getServerName() throws RemoteException {
		return editor.getServerName();
	}
}
