/*
 * $Header: /cvsroot/f-11/F-11/src/org/F11/scada/server/io/ValueListHandler.java,v 1.7 2003/10/15 08:36:51 frdm Exp $
 * $Revision: 1.7 $
 * $Date: 2003/10/15 08:36:51 $
 * 
 * =============================================================================
 * Projrct F-11 - Web SCADA for Java
 * Copyright (C) 2002 Freedom, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.F11.scada.server.io;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.SortedMap;

/**
 * MOf[^̃nhE[gC^[tFCXłB
 * `ꂽMOf[^RMIoRāAf[^Xg[Wǂ݂Ƃ܂B
 */
public interface ValueListHandler extends Remote {
	/**
	 * R[hIuWFNgԂ܂B
	 * @param name nh
	 * @return R[hIuWFNg
	 */
	public Object next(String name) throws RemoteException;

	/**
	 * ̃R[hIuWFNg݂鎞́Atrue Ԃ܂B
	 * @param name nh
	 * @return ̃R[hIuWFNg݂鎞́Atrue łȂꍇ false Ԃ܂B
	 */
	public boolean hasNext(String name) throws RemoteException;

	/**
	 * ŏ̃^CX^vԂ܂B
	 * @param name nh
	 */
	public Object firstKey(String name) throws RemoteException;

	/**
	 * Ō̃^CX^vԂ܂B
	 * @param name nh
	 */
	public Object lastKey(String name) throws RemoteException;

	/**
	 * ^CX^v key ȑÕR[hA|C^ʒuÂ܂B
	 * ̃\bhňʒuÂꂽ|C^́A key ȑÕR[hP܂݂܂B
	 * AAkey 擪R[hȑÕR[hꍇ́A擪R[hɂȂ܂B
	 * @param name nh
	 * @param key 郌R[h̃^CX^v
	 */
	public void findRecord(String name, Timestamp key) throws RemoteException;
	
	/**
	 * keyŎw肳ꂽȍ~̃MOf[^MapCX^XŕԂ܂B
	 * @param name nh
	 * @param key XV
	 */
	public Map getUpdateLoggingData(String name, Timestamp key) throws RemoteException;
	
	/**
	 * pf[^SortedMapԂ܂B
	 * @param name nh
	 * @return pf[^SortedMapԂ܂B
	 */
	public SortedMap getInitialData(String name) throws RemoteException;

	/**
	 * ̃nhԂ܂B
	 * 
	 * @param name nh
	 * @return ̃nhԂ܂B
	 */
	ValueListHandlerElement getValueListHandlerElement(String name) throws RemoteException;

}
