/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.ResultSetUtil;
import org.seasar.extension.jdbc.impl.ResultSetWrapper;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;

class PagerResultSetWrapper
extends ResultSetWrapper {
    private static final Logger LOGGER = Logger.getLogger((Class)PagerResultSetWrapper.class);
    private int counter = 0;
    private ResultSet original;
    private PagerCondition condition;
    private boolean useAbsolute = true;

    public void setUseAbsolute(boolean useAbsolute) {
        this.useAbsolute = useAbsolute;
    }

    public PagerResultSetWrapper(ResultSet original, PagerCondition condition, boolean useAbsolute) {
        super(original);
        this.original = original;
        this.condition = condition;
        this.useAbsolute = useAbsolute;
        this.moveOffset();
    }

    private void moveOffset() {
        if (this.isUseCursor()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"S2Pager use scroll cursor.");
            }
            try {
                if (0 == this.condition.getOffset()) {
                    this.original.beforeFirst();
                } else {
                    this.original.absolute(this.condition.getOffset());
                }
                this.counter = this.original.getRow();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"S2Pager not use scroll cursor.");
        }
        try {
            while (this.original.getRow() < this.condition.getOffset() && this.original.next()) {
                ++this.counter;
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public boolean next() throws SQLException {
        boolean next = super.next();
        if ((this.condition.getLimit() == -1 || this.counter < this.condition.getOffset() + this.condition.getLimit()) && next) {
            ++this.counter;
            return true;
        }
        if (this.isUseCursor()) {
            this.original.last();
            int count = this.original.getRow();
            this.condition.setCount(count);
        } else {
            if (next) {
                ++this.counter;
                while (this.original.next()) {
                    ++this.counter;
                }
            }
            this.condition.setCount(this.counter);
        }
        return false;
    }

    private boolean isUseCursor() {
        return this.useAbsolute && ResultSetUtil.isCursorSupport(this.original);
    }
}

