/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public abstract class AbstractSearchTool
implements ViewTool {
    public static final int DEFAULT_ITEMS_PER_PAGE = 10;
    public static final int DEFAULT_SLIP_SIZE = 20;
    protected static final String STORED_RESULTS_KEY = (class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults == null ? (class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults = AbstractSearchTool.class$("org.apache.velocity.tools.view.tools.AbstractSearchTool$StoredResults")) : class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults).getName();
    private List results;
    private Object criteria;
    private int index = 0;
    private int slipSize = 20;
    private int itemsPerPage = 10;
    protected HttpSession session;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$tools$AbstractSearchTool$StoredResults;

    public void init(Object obj) {
        ViewContext context = (ViewContext)obj;
        HttpServletRequest request = context.getRequest();
        this.session = request.getSession(false);
        this.setup(request);
    }

    public abstract void setup(HttpServletRequest var1);

    public void reset() {
        this.results = null;
        this.criteria = null;
        this.index = 0;
        this.itemsPerPage = 10;
    }

    public void setCriteria(Object criteria) {
        this.criteria = criteria;
        this.results = null;
    }

    public void setIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        this.index = index;
    }

    public void setItemsPerPage(int itemsPerPage) {
        if (itemsPerPage < 1) {
            itemsPerPage = 10;
        }
        this.itemsPerPage = itemsPerPage;
    }

    public void setSlipSize(int slipSize) {
        if (slipSize < 2) {
            slipSize = 20;
        }
        this.slipSize = slipSize;
    }

    public Object getCriteria() {
        return this.criteria;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getSlipSize() {
        return this.slipSize;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasResults() {
        return !this.getResults().isEmpty();
    }

    public List getResults() {
        if (this.results == null) {
            this.results = this.retrieveResults();
        }
        return this.results;
    }

    public Integer getNextIndex() {
        int next = this.index + this.itemsPerPage;
        if (next < this.getResults().size()) {
            return new Integer(next);
        }
        return null;
    }

    public Integer getPrevIndex() {
        int prev = Math.min(this.index, this.getResults().size()) - this.itemsPerPage;
        if (this.index > 0) {
            return new Integer(Math.max(0, prev));
        }
        return null;
    }

    public int getPagesAvailable() {
        return (int)Math.ceil((double)this.getResults().size() / (double)this.itemsPerPage);
    }

    public List getPage() {
        if (!this.hasResults()) {
            return null;
        }
        int start = Math.min(this.getResults().size() - 1, this.index);
        int end = Math.min(this.getResults().size(), this.index + this.itemsPerPage);
        return this.getResults().subList(start, end);
    }

    public Integer getPageNumber(int i) {
        if (!this.hasResults()) {
            return null;
        }
        return new Integer(1 + i / this.itemsPerPage);
    }

    public Integer getPageNumber() {
        return this.getPageNumber(this.index);
    }

    public String getPageDescription() {
        StringBuffer out = new StringBuffer();
        int first = this.index + 1;
        int total = this.getResults().size();
        if (first >= total) {
            out.append(total);
            out.append(" of ");
            out.append(total);
        } else {
            int last = Math.min(this.index + this.itemsPerPage, total);
            out.append(first);
            out.append(" - ");
            out.append(last);
            out.append(" of ");
            out.append(total);
        }
        return out.toString();
    }

    public List getSlip() {
        int adjSlipSize;
        int totalPgs = this.getPagesAvailable();
        if (totalPgs <= 1) {
            return Collections.EMPTY_LIST;
        }
        int curPg = this.getPageNumber() - 1;
        int slipStart = Math.max(0, curPg - (adjSlipSize = this.slipSize - 1) / 2);
        int slipEnd = Math.min(totalPgs, slipStart + adjSlipSize);
        if (slipEnd - slipStart < adjSlipSize) {
            slipStart = Math.max(0, slipEnd - adjSlipSize);
        }
        ArrayList<Integer> slip = new ArrayList<Integer>(slipEnd - slipStart + 1);
        int i = slipStart;
        while (i < slipEnd) {
            slip.add(new Integer(i * this.itemsPerPage));
            ++i;
        }
        return slip;
    }

    private List retrieveResults() {
        if (this.criteria == null) {
            return Collections.EMPTY_LIST;
        }
        StoredResults sr = this.getStoredResults();
        if (sr != null && this.criteria.equals(sr.getCriteria())) {
            return sr.getList();
        }
        List list = this.executeQuery(this.criteria);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        this.setStoredResults(new StoredResults(this.criteria, list));
        return list;
    }

    protected abstract List executeQuery(Object var1);

    protected StoredResults getStoredResults() {
        if (this.session != null) {
            return (StoredResults)this.session.getAttribute(STORED_RESULTS_KEY);
        }
        return null;
    }

    protected void setStoredResults(StoredResults results) {
        if (this.session != null) {
            this.session.setAttribute(STORED_RESULTS_KEY, (Object)results);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class StoredResults
    implements Serializable {
        private transient Object crit;
        private transient List list;

        public StoredResults(Object crit, List list) {
            this.crit = crit;
            this.list = list;
        }

        public Object getCriteria() {
            return this.crit;
        }

        public List getList() {
            return this.list;
        }
    }
}

