/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.framework.exception.SQLRuntimeException;

class ResultSetUtil {
    ResultSetUtil() {
    }

    public static int autoAbsolute(ResultSet resultSet, int offset) throws SQLException {
        block4: {
            if (ResultSetUtil.isCursorSupport(resultSet)) {
                try {
                    if (offset != resultSet.getRow()) {
                        resultSet.absolute(offset);
                        return resultSet.getRow();
                    }
                    break block4;
                }
                catch (SQLException e) {
                    return ResultSetUtil.manualAbsolute(resultSet, offset);
                }
            }
            return ResultSetUtil.manualAbsolute(resultSet, offset);
        }
        return 0;
    }

    private static int manualAbsolute(ResultSet resultSet, int offset) throws SQLException {
        int count = 0;
        while (resultSet.getRow() < offset && resultSet.next()) {
            ++count;
        }
        return count;
    }

    public static boolean autoLast(ResultSet resultSet) throws SQLException {
        if (ResultSetUtil.isCursorSupport(resultSet)) {
            try {
                resultSet.last();
                return true;
            }
            catch (SQLException e) {
                ResultSetUtil.manualLast(resultSet);
                return false;
            }
        }
        ResultSetUtil.manualLast(resultSet);
        return false;
    }

    public static boolean isCursorSupport(ResultSet resultSet) {
        try {
            return resultSet.getType() != 1003;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private static void manualLast(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
    }
}

