/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.impl.AbstractAutoHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public abstract class AbstractBatchAutoHandler
extends AbstractAutoHandler {
    public AbstractBatchAutoHandler(DataSource dataSource, StatementFactory statementFactory, BeanMetaData beanMetaData, PropertyType[] propertyTypes) {
        super(dataSource, statementFactory, beanMetaData, propertyTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args) throws SQLRuntimeException {
        Connection connection = this.getConnection();
        try {
            Object[] beans = null;
            if (args[0] instanceof Object[]) {
                beans = (Object[])args[0];
            } else if (args[0] instanceof List) {
                beans = ((List)args[0]).toArray();
            }
            if (beans == null) {
                throw new IllegalArgumentException("args[0]");
            }
            PreparedStatement ps = this.prepareStatement(connection);
            try {
                for (int i = 0; i < beans.length; ++i) {
                    this.execute(ps, beans[i]);
                }
                PreparedStatementUtil.executeBatch((PreparedStatement)ps);
            }
            finally {
                StatementUtil.close((Statement)ps);
            }
            int n = beans.length;
            return n;
        }
        finally {
            ConnectionUtil.close((Connection)connection);
        }
    }

    protected void execute(PreparedStatement ps, Object bean) {
        this.setupBindVariables(bean);
        if (AbstractBatchAutoHandler.getLogger().isDebugEnabled()) {
            AbstractBatchAutoHandler.getLogger().debug((Object)this.getCompleteSql(this.getBindVariables()));
        }
        this.bindArgs(ps, this.getBindVariables(), this.getBindVariableValueTypes());
        PreparedStatementUtil.addBatch((PreparedStatement)ps);
    }
}

