/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.NumberFunction;

public class RoundFunction
implements Function {
    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() == 1) {
            return RoundFunction.evaluate(args.get(1), context.getNavigator());
        }
        throw new FunctionCallException("round() requires one argument.");
    }

    public static Number evaluate(Object obj, Navigator nav) {
        Double d;
        Number n = NumberFunction.evaluate(obj, nav);
        if (n instanceof Double && ((d = (Double)n).isNaN() || d.isInfinite())) {
            return d;
        }
        double value = n.doubleValue();
        return new Long(Math.round(value));
    }
}

