/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.javacons.jim;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import jp.gr.javacons.jim.DataHolder;
import jp.gr.javacons.jim.DataProvider;
import jp.gr.javacons.jim.DataReferencerEditor;
import jp.gr.javacons.jim.Manager;
import jp.gr.javacons.jim.Utility;

class DataReferencerCustomEditor
extends Panel {
    private static final long serialVersionUID = -7913073849952010312L;
    private Label dataProviderLabel;
    private Choice dataProviderChoice;
    private Label dataHolderLabel;
    private Choice dataHolderChoice;
    private Label dataHolderTypeLabel;
    private Button newButton;
    private ScrollPane scrollPane;
    private Manager manager = Manager.getInstance();
    private DataProvider dataProvider;
    private DataHolder dataHolder;
    private DataReferencerEditor editor;
    private String oldDataProviderName = "";
    private String oldDataHolderName = "";
    static final ResourceBundle res = ResourceBundle.getBundle("jp.gr.javacons.jim.DataReferencerCEResBundle", Locale.getDefault());

    DataReferencerCustomEditor(DataReferencerEditor editor) {
        this.editor = editor;
        this.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        this.dataProviderLabel = new Label(res.getString("dpn"));
        c.anchor = 13;
        gbl.setConstraints(this.dataProviderLabel, c);
        this.add(this.dataProviderLabel);
        this.dataProviderChoice = new Choice();
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.gridx = -1;
        c.gridwidth = -1;
        gbl.setConstraints(this.dataProviderChoice, c);
        this.add(this.dataProviderChoice);
        this.dataProviderChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DataReferencerCustomEditor.this.setDataProviderName((String)e.getItem());
                DataReferencerCustomEditor.this.setDataHolderName("");
                DataReferencerCustomEditor.this.dataProviderNameSelected();
            }
        });
        this.dataHolderLabel = new Label(res.getString("dhn"));
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        gbl.setConstraints(this.dataHolderLabel, c);
        this.add(this.dataHolderLabel);
        this.dataHolderChoice = new Choice();
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.gridx = -1;
        c.gridwidth = -1;
        gbl.setConstraints(this.dataHolderChoice, c);
        this.add(this.dataHolderChoice);
        this.dataHolderChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DataReferencerCustomEditor.this.setDataHolderName((String)e.getItem());
                DataReferencerCustomEditor.this.dataHolderNameSelected();
            }
        });
        this.newButton = new Button(res.getString("new."));
        c.weightx = 0.0;
        c.gridx = -1;
        c.gridwidth = 0;
        gbl.setConstraints(this.newButton, c);
        this.add(this.newButton);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataReferencerCustomEditor.this.doNew();
            }
        });
        Label l = new Label(res.getString("dht"));
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 1;
        c.gridy = 3;
        c.gridx = 0;
        gbl.setConstraints(l, c);
        this.add(l);
        this.dataHolderTypeLabel = new Label();
        c.fill = 1;
        c.anchor = 17;
        c.gridx = -1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        gbl.setConstraints(this.dataHolderTypeLabel, c);
        this.add(this.dataHolderTypeLabel);
        this.scrollPane = new ScrollPane(1){
            private static final long serialVersionUID = 4720399578356936617L;

            public Dimension getMinimumSize() {
                return new Dimension(400, 150);
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 150);
            }
        };
        c.gridx = 0;
        c.gridy = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = -1;
        c.gridheight = 0;
        gbl.setConstraints(this.scrollPane, c);
        this.add(this.scrollPane);
        this.oldDataProviderName = editor.getDataProviderName();
        this.oldDataHolderName = editor.getDataHolderName();
        this.dataProviderChoice.removeAll();
        this.dataProviderChoice.add("");
        DataProvider[] providers = this.manager.getDataProviders();
        String dataProviderName = this.oldDataProviderName;
        for (int i = 0; i < providers.length; ++i) {
            this.dataProviderChoice.add(providers[i].getDataProviderName());
        }
        this.dataProviderChoice.select(dataProviderName);
        if (!this.dataProviderChoice.getSelectedItem().equals(dataProviderName)) {
            this.dataProviderChoice.add(this.oldDataProviderName);
            this.dataProviderChoice.select(this.dataProviderChoice.getItemCount() - 1);
        }
        this.dataProviderNameSelected();
    }

    void dataHolderNameSelected() {
        String dataHolderName = this.editor.getDataHolderName();
        Component c = new Label("");
        this.dataHolder = this.manager.findDataHolder(this.editor.getDataProviderName(), dataHolderName);
        if (this.dataHolder == null) {
            this.dataHolderLabel.setForeground(Color.red);
            this.dataHolderTypeLabel.setText("");
            if ("".equals(this.editor.getDataProviderName())) {
                this.dataProviderLabel.setForeground(Color.red);
                c = new Label(res.getString("set_dp"));
            } else if (this.dataProvider == null) {
                this.dataProviderLabel.setForeground(Color.red);
            } else if ("".equals(dataHolderName)) {
                this.dataHolderLabel.setForeground(Color.red);
                c = new Label(res.getString("set_dh"));
            } else {
                this.dataHolderLabel.setForeground(Color.red);
            }
        } else {
            this.dataProviderLabel.setForeground(Color.black);
            this.dataHolderLabel.setForeground(Color.black);
            this.dataHolderTypeLabel.setText(this.getTypeString(this.dataHolder));
            c = Manager.getDataHolderPropertyListPanel(this.dataHolder);
        }
        this.showDataHolderPropertyEditor(c);
    }

    void dataProviderNameSelected() {
        String dataProviderName = this.editor.getDataProviderName();
        String dataHolderName = this.editor.getDataHolderName();
        this.dataProvider = this.manager.getDataProvider(dataProviderName);
        this.dataHolderChoice.setVisible(false);
        this.dataHolderChoice.removeAll();
        this.dataHolderChoice.add("");
        if (this.dataProvider != null) {
            this.dataProviderLabel.setForeground(Color.black);
            DataHolder[] dhs = this.dataProvider.getDataHolders();
            for (int i = 0; i < dhs.length; ++i) {
                if (!this.isSelectableDataHolder(dhs[i])) continue;
                this.dataHolderChoice.add(dhs[i].getDataHolderName());
            }
            if (dataProviderName.equals(this.oldDataProviderName) && this.dataProvider.getDataHolder(this.oldDataHolderName) == null) {
                this.dataHolderChoice.add(this.oldDataHolderName);
            }
            this.dataHolderChoice.select(dataHolderName);
            this.newButton.setEnabled(this.dataProvider.canAddDataHolderByUser() && this.getSelectableDataHolderTypeInfo().length != 0);
        } else {
            this.dataProviderLabel.setForeground(Color.red);
            if (!"".equals(dataProviderName) && !"".equals(this.oldDataHolderName)) {
                this.dataHolderChoice.add(this.oldDataHolderName);
                this.dataHolderChoice.select(dataHolderName);
            }
            this.newButton.setEnabled(false);
        }
        this.dataHolderChoice.setVisible(true);
        this.dataHolderNameSelected();
    }

    void doNew() {
        Frame parent = Utility.getRootFrame(this);
        if ("".equals(this.dataProviderChoice.getSelectedItem())) {
            Utility.showMessage(parent, res.getString("set_dp"));
            return;
        }
        DataHolder newDH = Utility.getDataProviderCustomizerHelper(this.dataProvider).addNewDataHolder(parent, this.dataProvider, this.getSelectableDataHolderTypeInfo());
        if (newDH == null) {
            return;
        }
        this.setDataHolderName(newDH.getDataHolderName());
        this.dataProviderNameSelected();
    }

    Class[][] getSelectableDataHolderTypeInfo() {
        Vector<Class[]> sVect = new Vector<Class[]>();
        Class[][] pType = this.dataProvider.getProvidableDataHolderTypeInfoByUser();
        Class[][] rType = this.editor.getDataReferencer().getReferableDataHolderTypeInfo();
        if (rType == null) {
            return new Class[0][0];
        }
        for (int i = 0; i < rType.length; ++i) {
            Class[] rvs = rType[i];
            Class dhc = rvs[0];
            for (int j = 0; j < pType.length; ++j) {
                Class[] pvs = pType[j];
                if (!dhc.isAssignableFrom(pvs[0])) continue;
                if (rvs.length == 1) {
                    for (int l = 1; l < pvs.length; ++l) {
                        sVect.addElement(new Class[]{pvs[0], pvs[l]});
                    }
                    continue;
                }
                for (int k = 1; k < rvs.length; ++k) {
                    for (int m = 1; m < pvs.length; ++m) {
                        if (!rvs[k].isAssignableFrom(pvs[m])) continue;
                        sVect.addElement(new Class[]{pvs[0], pvs[m]});
                    }
                }
            }
        }
        Class[][] sType = new Class[sVect.size()][];
        sVect.copyInto((Object[])sType);
        return sType;
    }

    String getTypeString(Class dataHolderClass, Class valueClass) {
        String tStr = this.dataProvider.getDataHolderTypeString(dataHolderClass, valueClass);
        if (tStr == null) {
            tStr = Manager.getInstance().getDefaultDataHolderTypeString(dataHolderClass, valueClass);
        }
        return tStr;
    }

    String getTypeString(DataHolder dh) {
        return this.getTypeString(dh.getClass(), dh.getValueClass());
    }

    boolean isSelectableDataHolder(DataHolder dh) {
        Class[][] rType = this.editor.getDataReferencer().getReferableDataHolderTypeInfo();
        if (rType == null || rType.length == 0) {
            return false;
        }
        Class vc = dh.getValueClass();
        for (int i = 0; i < rType.length; ++i) {
            Class[] rts = rType[i];
            if (!rts[0].isInstance(dh)) continue;
            if (rts.length == 1) {
                return true;
            }
            for (int j = 1; j < rts.length; ++j) {
                if (!rts[j].isAssignableFrom(vc)) continue;
                return true;
            }
        }
        return false;
    }

    void setDataHolderName(String name) {
        this.editor.setDataHolderName(name);
    }

    void setDataProviderName(String name) {
        this.editor.setDataProviderName(name);
    }

    void showDataHolderPropertyEditor(Component component) {
        this.scrollPane.setVisible(false);
        this.scrollPane.removeAll();
        this.scrollPane.add(component);
        this.scrollPane.validate();
        this.scrollPane.setVisible(true);
    }
}

