/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class MessageTool
implements ViewTool {
    protected MessageResources resources;
    protected Locale locale;

    public void init(Object obj) {
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext context = (ViewContext)obj;
        HttpServletRequest request = context.getRequest();
        HttpSession session = request.getSession(false);
        ServletContext application = context.getServletContext();
        this.resources = StrutsUtils.getMessageResources(application);
        this.locale = StrutsUtils.getLocale(request, session);
    }

    public String get(String key) {
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return null;
        }
        return this.resources.getMessage(this.locale, key);
    }

    public String get(String key, Object[] args) {
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return null;
        }
        if (args == null) {
            return this.resources.getMessage(this.locale, key);
        }
        return this.resources.getMessage(this.locale, key, args);
    }

    public String get(String key, List args) {
        return this.get(key, args.toArray());
    }

    public boolean exists(String key) {
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return false;
        }
        return this.resources.isPresent(this.locale, key);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

