/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans;

import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.MethodUtil;

public final class MethodNotFoundRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = -3508955801981550317L;
    private Class targetClass_;
    private String methodName_;
    private Class[] methodArgClasses_;

    public MethodNotFoundRuntimeException(Class targetClass, String methodName, Object[] methodArgs) {
        super("ESSR0049", new Object[]{targetClass.getName(), MethodUtil.getSignature(methodName, methodArgs)});
        this.targetClass_ = targetClass;
        this.methodName_ = methodName;
        if (methodArgs != null) {
            this.methodArgClasses_ = new Class[methodArgs.length];
            for (int i = 0; i < methodArgs.length; ++i) {
                if (methodArgs[i] == null) continue;
                this.methodArgClasses_[i] = methodArgs[i].getClass();
            }
        }
    }

    public MethodNotFoundRuntimeException(Class targetClass, String methodName, Class[] methodArgClasses) {
        super("ESSR0049", new Object[]{targetClass.getName(), MethodUtil.getSignature(methodName, methodArgClasses)});
        this.targetClass_ = targetClass;
        this.methodName_ = methodName;
        this.methodArgClasses_ = methodArgClasses;
    }

    public Class getTargetClass() {
        return this.targetClass_;
    }

    public String getMethodName() {
        return this.methodName_;
    }

    public Class[] getMethodArgClasses() {
        return this.methodArgClasses_;
    }
}

